/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.dem.interfaces.IStageInstance;

/**
 * Min parameter constraint implementation
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public class ParameterConstraintMinImpl extends AbstractNumericParameterConstraint {

    /** Last tested value */
    Double lastTestedValue;

    /** Min value to compare to */
    Double minValue;

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#configureConstraint(java.lang.String)
     */
    public void configureConstraint(String configurationString)
    {

        String value = configurationString.substring(configurationString.indexOf("=") + 1);

        minValue = new Double(value.trim());
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint#getErrorMessageValues(boolean)
     */
    @Override
    protected Map<String, String> getErrorMessageValues(boolean parseValues)
    {
        Map<String, String> substitutions = new HashMap<String, String>();

        DecimalFormat df = new DecimalFormat("0");

        if (parseValues)
        {
            substitutions.put("value", df.format(lastTestedValue));
        }
        substitutions.put("min", df.format(minValue));

        return substitutions;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#getJavaScriptValidationCondition()
     */
    public String getJavaScriptValidationCondition()
    {
        return "parseInt(value) >= " + minValue;
    }

    /**
     * Inspector for the 'minValue' attribute.
     * 
     * @return the minValue value
     */
    public Double getMinValue()
    {
        return minValue;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.AbstractNumericParameterConstraint#validateConstraint(java.lang.Double,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(Double value, IStageInstance stageInstance)
    {

        lastTestedValue = value;

        return (value != null && value >= minValue);
    }
}
