/** 2007, Digitalis Informatica. All rights reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.errors;

/**
 * Describes the error that has occurred in a classification type
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 *
 */
public enum ParameterErrorType {

    /** A constraint has been violated */
    CONSTRAINT,

    /** A validator has been violated */
    VALIDATOR,

    /** A rule has been violated */
    RULE,

    /** No session was available for the session scoped parameter */
    NO_SESSION,

    /** Required parameter missing */
    MISSING,

    /** No user in session was available for the user scoped parameter */
    NO_USER,

    /** Another rule has been violated */
    OTHER;
}
