/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.exception;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.exception.ExceptionUtils;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.StringUtils;

/**
 * Base class for the framework Exceptions.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2007/03/16
 */
abstract public class DIFException extends Exception implements IContextException {

    /**  */
    private static final long serialVersionUID = -462214831205636575L;

    /** Exception context. */
    private Map<String, Object> exceptionContext;

    /**
     * Constructs a new DIFException that wraps a Java Exception.
     * 
     * @param exception
     *            the exception to encapsulate.
     */
    public DIFException(Exception exception)
    {
        super(exception);
    }

    /**
     * Constructs a new DIFException from a reason.
     * 
     * @param reason
     *            the exception reason.
     */
    public DIFException(String reason)
    {
        super(reason);
    }

    /**
     * Constructs a new DIFException from a reason and a Java Exception.
     * 
     * @param reason
     *            the exception reason.
     * @param exception
     *            the exception to encapsulate.
     */
    public DIFException(String reason, Exception exception)
    {
        super(reason, exception);
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#addToExceptionContext(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public IContextException addToExceptionContext(IDIFContext context)
    {
        if (context != null)
            this.addToExceptionContext("DIF Context", context);

        return this;
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#addToExceptionContext(java.util.Map)
     */
    public IContextException addToExceptionContext(Map<String, ?> values)
    {
        if (values != null)
            for (Entry<String, ?> entry: values.entrySet())
                this.addToExceptionContext(entry.getKey(), entry.getValue());

        return this;
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#addToExceptionContext(String, Object)
     */
    public IContextException addToExceptionContext(String key, Object value)
    {
        if (value != null)
        {
            if (this.exceptionContext == null)
                this.exceptionContext = new LinkedHashMap<String, Object>();

            this.exceptionContext.put(key, StringUtils.nvl(StringUtils.toStringOrNull(value), "NULL"));
        }

        return this;
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#getExceptionContext()
     */
    public Map<String, Object> getExceptionContext()
    {
        return exceptionContext;
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#getRenderedExceptionContext()
     */
    public String getRenderedExceptionContext()
    {

        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItemIfNotNull("Cause", getCause());
        formatter.addItemIfNotNull("Message", getMessage());
        formatter.addItemIfNotNull("Exception Context", exceptionContext);

        return "DIF Exception:\n" + formatter.getFormatedObject() + "\n";
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#log(pt.digitalis.log.LogLevel)
     */
    public void log(LogLevel level)
    {
        this.log(level, false);
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#log(pt.digitalis.log.LogLevel, boolean)
     */
    public void log(LogLevel level, boolean stackTraceOnlyForDebug)
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRenderedExceptionContext());

        if (!stackTraceOnlyForDebug || DIFLogger.getLogger().isDebugEnabled())
            buffer.append(ExceptionUtils.getStackTrace(this));

        DIFLogger.getLogger().log(level, buffer);
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#setExceptionContext(Map)
     */
    public IContextException setExceptionContext(Map<String, Object> exceptionContext)
    {
        if (this.exceptionContext == null)
            this.exceptionContext = new HashMap<String, Object>();

        this.exceptionContext = exceptionContext;

        return this;
    }
}