/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception;

import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.LogLevel;

/**
 * Defines the behavior associated with an exception with context.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2007/11/27
 */
public interface IContextException {

    /**
     * Adds the current context to the exception
     * 
     * @param context
     *            the current context
     * @return the updated object (fluent interface)
     */
    public IContextException addToExceptionContext(IDIFContext context);

    /**
     * Adds a new element to the exception context.
     * 
     * @param values
     *            several context parameters to add to the exception
     * @return the updated object (fluent interface)
     */
    public IContextException addToExceptionContext(Map<String, ?> values);

    /**
     * Adds a new element to the exception context.
     * 
     * @param key
     *            the element's key
     * @param value
     *            the element's value
     * @return the updated object (fluent interface)
     */
    public IContextException addToExceptionContext(String key, Object value);

    /**
     * Returns the exception context.
     * 
     * @return the exception context
     */
    public Map<String, Object> getExceptionContext();

    /**
     * Renders the exception context.
     * 
     * @return a String with the rendered context.
     */
    public String getRenderedExceptionContext();

    /**
     * Logs the business exception to the {@link DIFLogger}
     * 
     * @param level
     *            the log level to log
     */
    public void log(LogLevel level);

    /**
     * Logs the business exception to the {@link DIFLogger}
     * 
     * @param level
     *            the log level to log
     * @param stackTraceOnlyForDebug
     *            if T will only show stack trace if debug is enabled
     */
    public void log(LogLevel level, boolean stackTraceOnlyForDebug);

    /**
     * Sets the exception context.
     * 
     * @param exceptionContext
     *            a pre-built exception context
     * @return the updated object (fluent interface)
     */
    public IContextException setExceptionContext(Map<String, Object> exceptionContext);
}
