/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception.codegen;

import java.util.Map;

/**
 * Represents a DEM annotation misuse exception. It's an abstract class whose <code>translate()</code> must be
 * implemented on the subclasses. Defines the keys that should be used on the context by all subclasses.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/11/27
 */
abstract public class AnnotationMisuseException extends DIFCodeGenerationException {

    /** Nested static class which defines the keys used on the exception context. */
    static public class ContextKeys {

        /** The 'annotation scope' key. */
        final static public String ANNOTATION_SCOPE = "annotationScope";

        /** The 'annotation found' key. */
        final static public String ANNOTATIONS_FOUND = "annotationsFound";

        /** The 'attribute' key. */
        final static public String ATTRIBUTE = "attribute";

        /** The 'class' key. */
        final static public String CLASS = "class";

        /** The 'message' key. */
        final static public String MESSAGE = "message";

        /** The 'method' key. */
        final static public String METHOD = "method";
    };

    /** Serial Version ID. */
    private static final long serialVersionUID = 6690908007977245072L;

    /**
     * Constructs a new AnnotationMisuseException from a reason, an exception and an exception context.
     * 
     * @param reason
     *            the exception reason.
     * @param exception
     *            the exception to encapsulate.
     * @param exceptionContext
     *            the exception context.
     */
    public AnnotationMisuseException(String reason, Exception exception, Map<String, Object> exceptionContext)
    {
        super(reason, exception);
        super.setExceptionContext(exceptionContext);
    }

    /**
     * Constructs a new AnnotationMisuseException from a reason and an exception context.
     * 
     * @param reason
     *            the exception reason.
     * @param exceptionContext
     *            the exception context.
     */
    public AnnotationMisuseException(String reason, Map<String, Object> exceptionContext)
    {
        super(reason);
        super.setExceptionContext(exceptionContext);
    }
}
