/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.exception.security;

import pt.digitalis.dif.exception.DIFException;

/**
 * Authentication manager related exception.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/21
 */
public class AuthenticationManagerException extends DIFException {

    /** The serial ID. */
    final static private long serialVersionUID = 1L;

    /**
     * Constructs a new AuthenticationManagerException that wraps a Java Exception.
     * 
     * @param exception
     *            the exception to encapsulate.
     */
    public AuthenticationManagerException(Exception exception) {
        super(exception);
    }

    /**
     * Constructs a new AuthenticationManagerException from a reason and a Java Exception.
     * 
     * @param reason
     *            the exception reason.
     * @param exception
     *            the exception to encapsulate.
     */
    public AuthenticationManagerException(String reason, Exception exception) {
        super(reason, exception);
    }

    /**
     * Constructs a new AuthenticationManagerException from a reason.
     * 
     * @param reason
     *            the exception reason.
     */
    public AuthenticationManagerException(String reason) {
        super(reason);
    }
}
