/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.codegen.util.ClassEnhancerImpl;
import pt.digitalis.dif.codegen.util.IClassEnhancer;
import pt.digitalis.dif.controller.sanitycheck.GeneralCheckUp;
import pt.digitalis.dif.dem.config.DEMRegistratorImpl;
import pt.digitalis.dif.dem.config.IDEMRegistrator;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.IParameterManager;
import pt.digitalis.dif.dem.managers.IRegistrationManager;
import pt.digitalis.dif.dem.managers.impl.DEMManagerImpl;
import pt.digitalis.dif.dem.managers.impl.MessageManagerImpl;
import pt.digitalis.dif.dem.managers.impl.ParameterManagerImpl;
import pt.digitalis.dif.dem.managers.impl.RegistrationManagerImpl;
import pt.digitalis.dif.dem.objects.ILicense;
import pt.digitalis.dif.dem.objects.LicenseImpl;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.dif.utils.logging.ErrorLogManagerDIFLoggerImpl;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.dif.utils.mail.sanitycheck.CheckMail;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Core Module of the DIF Framework. All services that support the core functionality are declared in this Module
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 2, 2007
 */
public class DIFCoreModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {

        // Code Generation Services
        binder.bind(IClassEnhancer.class, ClassEnhancerImpl.class).asSingleton();
        binder.bind(IDEMRegistrator.class, DEMRegistratorImpl.class).asSingleton();

        // DEM Managers
        binder.bind(IDEMManager.class, DEMManagerImpl.class).asSingleton();
        binder.bind(IRegistrationManager.class, RegistrationManagerImpl.class).asSingleton();
        binder.bind(IMessageManager.class, MessageManagerImpl.class).withId("static").asSingleton();
        binder.bind(IParameterManager.class, ParameterManagerImpl.class).asSingleton();

        // Core functionalities
        binder.bind(IConfigurations.class, ConfigurationsPreferencesImpl.class).asSingleton();

        // Utilities
        binder.bind(ILicense.class, LicenseImpl.class);
        binder.bind(IErrorLogManager.class, ErrorLogManagerDIFLoggerImpl.class).asSingleton();

        // Other Modules...
        binder.install(new ControllerModule());
        binder.install(new StaticSecurityModule());
        binder.install(new ParametersModule());
        binder.install(new DIFCoreSanityCheckModule());

        // Custom selected modules
        binder.install(new DefaultModulesSeleccionModule());

        // Sanity checks
        binder.bind(ISanityCheckTestSuite.class, CheckMail.class).withId("SanityCheckMail");
        binder.bind(ISanityCheckTestSuite.class, GeneralCheckUp.class).withId("SanityCheckGeneral");
    }
}
