/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.security.managers.IAuthenticationManager;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.ioc.modules.IIoCDynamicModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;
import pt.digitalis.utils.ioc.modules.IoCBinding;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 4 de Fev de 2011
 */
public class DefaultModulesSeleccionModule implements IIoCDynamicModule {

    /**  */
    private DIFDefaultModulesConfiguration moduleConfig = DIFDefaultModulesConfiguration.getInstance();

    /**
     * @param binder
     * @param serviceClass
     *            to bind
     */
    private void bindDefaultModule(IoCBinder binder, Class<?> serviceClass)
    {
        IoCBinding previousBinding = moduleConfig.getDefaultImplementationBindingFor(serviceClass);
        IoCBinding newDefaultBinding = null;

        if (previousBinding != null)
        {
            newDefaultBinding = binder.bind(serviceClass, previousBinding.getImplementationType());
            if (previousBinding.isSingleton())
                newDefaultBinding.asSingleton();

            DIFLogger.getLogger().info(
                    "    => "
                            + StringUtils.camelCaseToString(previousBinding.getInterfaceType().getSimpleName()
                                    .substring(1)) + ": " + previousBinding.getId() + " ("
                            + previousBinding.getImplementationType().getSimpleName() + ")");
        }
        else
        {
            DIFLogger.getLogger().warn("    => " + "No bindings for: " + serviceClass.getCanonicalName());
        }
    }

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        DIFLogger.getLogger().info("Core Module Resolution");

        bindDefaultModule(binder, IMessageManager.class);
        bindDefaultModule(binder, IIdentityManager.class);
        bindDefaultModule(binder, IAuthenticationManager.class);
        bindDefaultModule(binder, IAuthorizationManager.class);

        DIFLogger.getLogger().info("");
    }
}