package pt.digitalis.dif.sanitycheck.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 14 de Jul de 2011
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface SanityCheckDependency {

    /**
     * The name of the SanityCheckTestSuite that must be ran before the current declared test suite
     * 
     * @return the name
     */
    public String value();
}
