/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.cache;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 16 de Mar de 2011
 */
public enum CacheScope {

    /** For all requests, if no other level exists */
    GLOBAL,

    /** Group scope. for every session of a user of this group. Will take precedence over GLOBAL scope **/
    GROUP,

    /** Session scope. Ends with session and is saved within it. Will take precedence above all others */
    SESSION,

    /** User scope. for every session of the same user. Will take precedence over GROUP and GLOBAL scopes */
    USER;

    /**
     * @param groupID
     * @return a GROUP instance with the specific group defined
     */
    public static CacheScope GROUPInstance(String groupID)
    {
        CacheScope instance = GROUP;
        instance.setScopeID(groupID);

        return instance;
    }

    /**
     * @param sessionID
     * @return a SESION instance with the specific session defined
     */
    public static CacheScope SESSIONInstance(String sessionID)
    {
        CacheScope instance = SESSION;
        instance.setScopeID(sessionID);

        return instance;
    }

    /**
     * @param userID
     * @return a USER instance with the specific user defined
     */
    public static CacheScope USERInstance(String userID)
    {
        CacheScope instance = USER;
        instance.setScopeID(userID);

        return instance;
    }

    /**  */
    private String scopeID;

    /**
     * Inspector for the 'scopeID' attribute.
     * 
     * @return the scopeID value
     */
    protected String getScopeID()
    {
        return scopeID;
    }

    /**
     * Modifier for the 'scopeID' attribute.
     * 
     * @param scopeID
     *            the new scopeID value to set
     */
    protected void setScopeID(String scopeID)
    {
        this.scopeID = scopeID;
    }
}