/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.cms.exception;

/**
 * This exception occurs when there is an operation on a Node or a ContentItem object when this object was already
 * deleted in the repository
 * 
 * @author Nuno Bravo
 * @created Out 20, 2010
 */
public class AlreadyDeletedException extends ContentManagerException {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     */
    public AlreadyDeletedException()
    {
        super("Element has already been deleted");
    }

    /**
     * @param exception
     */
    public AlreadyDeletedException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param nodeId
     */
    public AlreadyDeletedException(Long nodeId)
    {
        super("Element has already been deleted. Id: " + nodeId);
    }

    /**
     * @param reason
     */
    public AlreadyDeletedException(String reason)
    {
        super(reason);
    }

}
