/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.log.LogLevel;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public class DIFJobsManager {

    /**  */
    static public Map<String, DIFJob> jobs = new HashMap<String, DIFJob>();

    /**
     * Adds a job to the manager<br/>
     * Will start it if it is configured as active.
     * 
     * @param job
     *            the job to add
     */
    public static void addJob(DIFJob job)
    {
        if (job.getJobType() == JobType.SINGLE_EXECUTION)
        {
            new BusinessException("Cannot add SINGLE_EXECUTION jobs to the DIF Jobs Manager").addToExceptionContext(
                    "Job", job).log(LogLevel.WARN);
        }
        else
        {
            jobs.put(job.getClass().getSimpleName(), job);

            // TODO: ComQuest: Viegas: 0. Implement persistent props and read configs here
            // TODO: ComQuest: Viegas: 0. Create Job manager interface
            job.start();
        }
    }
}
