/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;


/**
 * Base class for a recurrent job. Runs forever a set intervals
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public abstract class RecurrentJob extends DIFJob {

    /**
     * In this case no session makes sense to pass. A RecurrentJob is a System Job and not a user task
     */
    public RecurrentJob()
    {
        super(null);
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getJobType()
     */
    @Override
    public JobType getJobType()
    {
        return JobType.RECURRENT;
    }
}
