/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.jobs;

import pt.digitalis.dif.controller.interfaces.IDIFSession;

/**
 * Base class for a recurrent job.<br/>
 * Runs only one time (not meant to be added to {@link DIFJobsManager}, but instead ran directly with ".start")
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public abstract class SingleRunJob extends DIFJob {

    /**
     * @param session
     *            the current dif session. Null if none available (in this case any DB operations will be audited like
     *            DIF)
     */
    public SingleRunJob(IDIFSession session)
    {
        super(session);
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getDefaultRunIntervalInSeconds()
     */
    @Override
    protected Long getDefaultRunIntervalInSeconds()
    {
        // Will be discarded either way. Only relevant to recurrent jobs
        return 0L;
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getJobType()
     */
    @Override
    public JobType getJobType()
    {
        return JobType.SINGLE_EXECUTION;
    }
}
