/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 25/11/2015
 */
public class AuditContext {

    /** the app name */
    private static String appName;

    /** the app per thread repository instance */
    private static ThreadLocal<String> processPerThread = new ThreadLocal<String>();

    /** the user per thread repository instance */
    private static ThreadLocal<String> userPerThread = new ThreadLocal<String>();

    /**
     * Inspector for the 'appName' attribute.
     * 
     * @return the appName value
     */
    public static String getAppName()
    {
        return appName;
    }

    /**
     * @return the process name for the current thread
     */
    public static String getProcessNameForCurrentThread()
    {
        return processPerThread.get();
    }

    /**
     * @return the userName for the current thread
     */
    public static String getUserForCurrentThread()
    {
        return userPerThread.get();
    }

    /**
     * Modifier for the 'appName' attribute.
     * 
     * @param appName
     *            the new appName value to set
     */
    public static void setAppName(String appName)
    {
        AuditContext.appName = appName;
    }

    /**
     * Store the process name for the current thread.
     * 
     * @param processName
     *            Cannot be null or empty.
     */
    public static void setProcessNameForCurrentThread(String processName)
    {
        processPerThread.set(processName);
    }

    /**
     * Store the user for the current thread.
     * 
     * @param user
     *            Cannot be null or empty.
     */
    public static void setUserForCurrentThread(String user)
    {
        userPerThread.set(user);
    }

}
