/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica.
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.utils.logging;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;

import pt.digitalis.log.LogLevel;

/**
 * This aspect performs the tracing duties on the framework's core. Since tracing is cross cutting concern it can be
 * implemented with AOP and thus the tracing mechanism can be made independent of the core logic.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/17
 */

public aspect DIFCoreTracingAspect extends DIFLogAspect {

    /* --- Advices --- */

    /** Traces successful object construction. */
    after() : allConstructors()  
    {
        if (super.getLogger().isTraceEnabled()) {

            JoinPoint.StaticPart joinPointStaticPart = thisJoinPointStaticPart;
            
            // If it's not a join point on generated source code get it's signature
            if (joinPointStaticPart != null) {
                super.getLogger().increaseIndentation();

                Signature signature = joinPointStaticPart.getSignature();
                super.getLogger().log(
                        LogLevel.TRACE,
                        super.getLogger().getIndentationString() + "Constructed: "
                                + signature.getDeclaringType().getName());

                super.getLogger().decreaseIndentation();
            }
        }
    }

    /** Traces all methods entering. */
    before() : allMethods() 
    {
        if (super.getLogger().isTraceEnabled()) {
            super.getLogger().increaseIndentation();

            JoinPoint.StaticPart joinPointStaticPart = thisJoinPointStaticPart;
            
            // If it's not a join point on generated source code get it's signature
            if (joinPointStaticPart != null) {
                Signature signature = joinPointStaticPart.getSignature();
                super.getLogger().log(
                        LogLevel.TRACE,
                        super.getLogger().getIndentationString() + "Entering: "
                                + signature.getDeclaringType().getName() + "." + signature.getName());
            }
        }

    }

    /** Traces all methods exiting. */
    after() : allMethods()   
    {
        if (super.getLogger().isTraceEnabled()) {

            JoinPoint.StaticPart joinPointStaticPart = thisJoinPointStaticPart;
            
            // If it's not a join point on generated source code get it's signature
            if (joinPointStaticPart != null) {
                Signature signature = joinPointStaticPart.getSignature();
                super.getLogger().log(
                        LogLevel.TRACE,
                        super.getLogger().getIndentationString() + "Exiting: " + signature.getDeclaringType().getName()
                                + "." + signature.getName());
            }

            super.getLogger().decreaseIndentation();
        }

    }
}
