package pt.digitalis.dif.utils.logging;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 16/04/2014
 */
public interface IErrorLogManager {

    /**
     * Log an error for a given process name
     * 
     * @param applicationName
     *            the application name
     * @param processName
     *            the process name
     * @param e
     */
    public void logError(String applicationName, String processName, Exception e);

    /**
     * Log an error for a given process name
     * 
     * @param applicationName
     *            the application name
     * @param processName
     *            the process name
     * @param errorDescription
     *            the error description
     */
    public void logError(String applicationName, String processName, String errorDescription);
}
