/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.mail;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.utils.pools.AbstractAction;

/**
 * A send mail action object
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Feb 18, 2009
 */
public class MailAction extends AbstractAction {

    /** The Serial version id for Serializable */
    static private final long serialVersionUID = 429211122232L;

    /** The mail address BCC field */
    private String addressBCC;

    /** The mail address CC field */
    private String addressCC;

    /** The mail address FROM field */
    private String addressFrom;

    /** The mail address TO field */
    private String addressTo;

    /** The attachment list */
    private List<String> attachments;

    /** The mail body content */
    private String body;

    /** The document repository entrys to attach */
    private List<DocumentRepositoryEntry> documentRepositoryEntries;

    /** The Mail sender Instance */
    private transient MailSender mailSenderInstance;

    /** The mail subject */
    private String subject;

    /** The mail MIME type */
    private MailType type;

    /**
     * @throws MessagingException
     * @throws AddressException
     * @see pt.digitalis.utils.pools.AbstractAction#doExecute()
     */
    @Override
    protected AbstractAction doExecute() throws AddressException, MessagingException
    {
        this.getMailSenderInstance().sendEmail(getType(), getAddressFrom(), getAddressTo(), getAddressCC(),
                getAddressBCC(), getSubject(), getBody(), this.getAttachments(), null,
                this.getDocumentRepositoryEntries());

        return this;
    }

    /**
     * Inspector for the 'adressBCC' attribute.
     * 
     * @return the adressBCC value
     */
    public String getAddressBCC()
    {
        return addressBCC;
    }

    /**
     * Inspector for the 'adressCC' attribute.
     * 
     * @return the adressCC value
     */
    public String getAddressCC()
    {
        return addressCC;
    }

    /**
     * Inspector for the 'adressFrom' attribute.
     * 
     * @return the adressFrom value
     */
    public String getAddressFrom()
    {
        return addressFrom;
    }

    /**
     * Inspector for the 'adressTo' attribute.
     * 
     * @return the adressTo value
     */
    public String getAddressTo()
    {
        return addressTo;
    }

    /**
     * Inspector for the 'attachments' attribute.
     * 
     * @return the attachments value
     */
    public List<String> getAttachments()
    {
        return attachments;
    }

    /**
     * Inspector for the 'body' attribute.
     * 
     * @return the body value
     */
    public String getBody()
    {
        return body;
    }

    /**
     * Inspector for the 'documentRepositoryEntries' attribute.
     * 
     * @return the documentRepositoryEntries value
     */
    public List<DocumentRepositoryEntry> getDocumentRepositoryEntries()
    {
        return documentRepositoryEntries;
    }

    /**
     * Inspector for the 'mailSenderInstance' attribute.
     * 
     * @return the mailSenderInstance value
     */
    public MailSender getMailSenderInstance()
    {
        return mailSenderInstance;
    }

    /**
     * @see pt.digitalis.utils.pools.AbstractAction#getProperties()
     */
    public Map<String, Object> getProperties()
    {
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("From", getAddressFrom());
        props.put("To", getAddressTo());
        props.put("CC", getAddressCC());
        props.put("BCC", getAddressBCC());
        props.put("Subject", getSubject());
        props.put("Type", getType().toString());
        props.put("Body", getBody());

        return props;
    }

    /**
     * Inspector for the 'subject' attribute.
     * 
     * @return the subject value
     */
    public String getSubject()
    {
        return subject;
    }

    /**
     * Inspector for the 'type' attribute.
     * 
     * @return the type value
     */
    public MailType getType()
    {
        return type;
    }

    /**
     * Modifier for the 'adressBCC' attribute.
     * 
     * @param adressBCC
     *            the new adressBCC value to set
     */
    public void setAddressBCC(String adressBCC)
    {
        this.addressBCC = adressBCC;
    }

    /**
     * Modifier for the 'adressCC' attribute.
     * 
     * @param adressCC
     *            the new adressCC value to set
     */
    public void setAddressCC(String adressCC)
    {
        this.addressCC = adressCC;
    }

    /**
     * Modifier for the 'adressFrom' attribute.
     * 
     * @param adressFrom
     *            the new adressFrom value to set
     */
    public void setAddressFrom(String adressFrom)
    {
        this.addressFrom = adressFrom;
    }

    /**
     * Modifier for the 'adressTo' attribute.
     * 
     * @param adressTo
     *            the new adressTo value to set
     */
    public void setAddressTo(String adressTo)
    {
        this.addressTo = adressTo;
    }

    /**
     * Modifier for the 'attachments' attribute.
     * 
     * @param attachments
     *            the new attachments value to set
     */
    public void setAttachments(List<String> attachments)
    {
        this.attachments = attachments;
    }

    /**
     * Modifier for the 'body' attribute.
     * 
     * @param body
     *            the new body value to set
     */
    public void setBody(String body)
    {
        this.body = body;
    }

    /**
     * Modifier for the 'documentRepositoryEntries' attribute.
     * 
     * @param documentRepositoryEntries
     *            the new documentRepositoryEntries value to set
     */
    public void setDocumentRepositoryEntries(List<DocumentRepositoryEntry> documentRepositoryEntries)
    {
        this.documentRepositoryEntries = documentRepositoryEntries;
    }

    /**
     * Modifier for the 'mailSenderInstance' attribute.
     * 
     * @param mailSenderInstance
     *            the new mailSenderInstance value to set
     */
    public void setMailSenderInstance(MailSender mailSenderInstance)
    {
        this.mailSenderInstance = mailSenderInstance;
    }

    /**
     * Modifier for the 'subject' attribute.
     * 
     * @param subject
     *            the new subject value to set
     */
    public void setSubject(String subject)
    {
        this.subject = subject;
    }

    /**
     * Modifier for the 'type' attribute.
     * 
     * @param type
     *            the new type value to set
     */
    public void setType(MailType type)
    {
        this.type = type;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("ID", getId());
        formatter.addItem("Status", getStatus());
        formatter.addItem("Reason", getReason());
        formatter.addItem("Reason Exception", getReasonException());

        formatter.addItemIfNotNull("Mail From", addressFrom);
        formatter.addItemIfNotNull("Mail To", addressTo);
        formatter.addItemIfNotNull("Mail CC", addressCC);
        formatter.addItemIfNotNull("Mail BCC", addressBCC);
        formatter.addItemIfNotNull("Mail Body", body);
        formatter.addItemIfNotNull("Mail Subject", subject);
        formatter.addItemIfNotNull("Mail Type", type);
        formatter.addItem("Enrollment Time", getEnrollmentTime());
        formatter.addItemIfNotNull("Execution Start Time", getExecutionStartTime());
        formatter.addItemIfNotNull("Execution End Time", getExecutionEndTime());
        formatter.addItemIfNotNull("Expiration Time", getExpirationTime());
        formatter.addItemIfNotNull("Waiting Threads", getWaitingThreads());

        return formatter.getFormatedObject();
    }
}