/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.translator;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Dec 17, 2009
 */

public class FieldDictionaryEntries {

    /** Empty Value */
    public static final String EMPTY_VALUE = "#emptyValue#";

    /** The Limited interval separator ex 1:4 give the numbers between 1 and 4 */
    private static final String LIMITED_INTERVAL_SEPARATOR = ":";

    /** None available Value */
    public static final String NONE_VALUE = "#noneValue#";

    /** Other values */
    public static final String OTHER = "OTHER";
    /** Same value */
    public static final String SAME_VALUE = "#SameValue#";
    /** Specific values separator ex: 1,2,3 give the number with the same value */
    private static final String VALUES_SEPARATOR = ",";

    /** The entries that have a direct conversion value */
    private Map<String, String> directConversion = new HashMap<String, String>();

    /** The entries defined by values intervals */
    private Map<String, String> intervals = new HashMap<String, String>();

    /**
     * Get all dictionary entries
     *
     * @return all entries
     */
    public Map<String, String> getEntries()
    {
        HashMap<String, String> allEntries = new HashMap<String, String>();
        allEntries.putAll(directConversion);
        allEntries.putAll(intervals);

        return allEntries;
    }

    /**
     * Get the value for a original value
     *
     * @param originalValue
     * @return the destination value
     */
    public String getValue(String originalValue)
    {
        String result = directConversion.get(originalValue);
        /*
         * Found the original value in the entries but the translation is null Example originalValue=1 and
         * translation=null
         */
        if (directConversion.containsKey(originalValue) && SAME_VALUE.equals(result))
            return originalValue;

        // The result wasn't found by direct convertion, so lets try intervals
        if (result == null)
        {
            for (Entry<String, String> entry: this.intervals.entrySet())
            {
                /*
                 * Test the range of values Example 1:3 (Original Values between 1 and 3)
                 */
                if (entry.getKey().contains(LIMITED_INTERVAL_SEPARATOR))
                {
                    String[] limiters = entry.getKey().split(LIMITED_INTERVAL_SEPARATOR);
                    /*
                     * The original value was found between the range defined Example the range of Original Values is
                     * 1:3 and the translation is 10
                     */
                    boolean insideInterval = false;
                    try
                    {
                        Double doubleValue = Double.valueOf(originalValue);
                        insideInterval = doubleValue >= Double.valueOf(limiters[0])
                                && doubleValue <= Double.valueOf(limiters[1]);
                    }
                    catch (NumberFormatException e)
                    {
                        insideInterval = originalValue.compareTo(limiters[0]) >= 0
                                && originalValue.compareTo(limiters[1]) <= 0;
                    }

                    // boolean insideInterval = originalValue.compareTo(limiters[0]) >= 0 &&
                    // originalValue.compareTo(limiters[1]) <= 0;
                    if (insideInterval && !SAME_VALUE.equals(entry.getValue()))
                        return entry.getValue(); // will return the value assigned in translation
                    else if (insideInterval)
                        return originalValue; // Example the range 1:3 with the translation SAMEVALUE will have the own
                    // input value
                    /*
                     * Test a list of declared values Example 1,2,3 (list of the original values 1,2 and 3)
                     */
                }
                else if (entry.getKey().contains(VALUES_SEPARATOR))
                {
                    String[] valuesSeparated = entry.getKey().split(VALUES_SEPARATOR);
                    for (String value: valuesSeparated)
                        /*
                         * Found the input value in a list
                         */
                        if (originalValue.equals(value) && !SAME_VALUE.equals(entry.getValue()))
                            return entry.getValue(); // if the translation is not SAMEVALUE return the translation ex
                        // 1,2,3 with translation 4
                        else if (originalValue.equals(value))
                            return originalValue; // the translation is null ex: 1,2,3 will be translation to null, so
                    // will return the input value
                }

            }
        }

        /*
         * A definio de o valor vazio "" ira dar o funcionamento a todos os outros valores que nao foram encontrados
         */
        if (directConversion.containsKey(OTHER) && result == null)
        {
            String theValue = directConversion.get(OTHER);
            if (SAME_VALUE.equals(theValue))
                return originalValue;
            else if (EMPTY_VALUE.equals(theValue))
                return "";
            else if (NONE_VALUE.equals(theValue))
                return null;
        }

        return result;
    }

    /**
     * Load Dictionary Entries *
     *
     * @param entries
     *            the dictionary entries
     */
    public void setEntries(Map<String, String> entries)
    {
        this.directConversion = new HashMap<String, String>();
        this.intervals = new HashMap<String, String>();

        for (Entry<String, String> theEntry: entries.entrySet())
        {
            if (theEntry.getKey().contains(LIMITED_INTERVAL_SEPARATOR) || theEntry.getKey().contains(VALUES_SEPARATOR))
                this.intervals.put(theEntry.getKey(), theEntry.getValue());
            else
                this.directConversion.put(theEntry.getKey(), theEntry.getValue());
        }
    }

}
