/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.translator;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDictionaryEntries {
    public static final String EMPTY_VALUE = "#emptyValue#";
    private static final String LIMITED_INTERVAL_SEPARATOR = ":";
    public static final String NONE_VALUE = "#noneValue#";
    public static final String OTHER = "OTHER";
    public static final String SAME_VALUE = "#SameValue#";
    private static final String VALUES_SEPARATOR = ",";
    private Map<String, String> directConversion = new HashMap<String, String>();
    private Map<String, String> intervals = new HashMap<String, String>();

    public Map<String, String> getEntries() {
        HashMap<String, String> allEntries = new HashMap<String, String>();
        allEntries.putAll(this.directConversion);
        allEntries.putAll(this.intervals);
        return allEntries;
    }

    public String getValue(String originalValue) {
        String result = this.directConversion.get(originalValue);
        if (this.directConversion.containsKey(originalValue) && SAME_VALUE.equals(result)) {
            return originalValue;
        }
        if (result == null) {
            for (Map.Entry<String, String> entry : this.intervals.entrySet()) {
                String[] valuesSeparated;
                if (entry.getKey().contains(LIMITED_INTERVAL_SEPARATOR)) {
                    String[] limiters = entry.getKey().split(LIMITED_INTERVAL_SEPARATOR);
                    boolean insideInterval = false;
                    try {
                        Double doubleValue = Double.valueOf(originalValue);
                        insideInterval = doubleValue >= Double.valueOf(limiters[0]) && doubleValue <= Double.valueOf(limiters[1]);
                    }
                    catch (NumberFormatException e) {
                        boolean bl = insideInterval = originalValue.compareTo(limiters[0]) >= 0 && originalValue.compareTo(limiters[1]) <= 0;
                    }
                    if (insideInterval && !SAME_VALUE.equals(entry.getValue())) {
                        return entry.getValue();
                    }
                    if (!insideInterval) continue;
                    return originalValue;
                }
                if (!entry.getKey().contains(VALUES_SEPARATOR)) continue;
                for (String value : valuesSeparated = entry.getKey().split(VALUES_SEPARATOR)) {
                    if (originalValue.equals(value) && !SAME_VALUE.equals(entry.getValue())) {
                        return entry.getValue();
                    }
                    if (!originalValue.equals(value)) continue;
                    return originalValue;
                }
            }
        }
        if (this.directConversion.containsKey(OTHER) && result == null) {
            String theValue = this.directConversion.get(OTHER);
            if (SAME_VALUE.equals(theValue)) {
                return originalValue;
            }
            if (EMPTY_VALUE.equals(theValue)) {
                return "";
            }
            if (NONE_VALUE.equals(theValue)) {
                return null;
            }
        }
        return result;
    }

    public void setEntries(Map<String, String> entries) {
        this.directConversion = new HashMap<String, String>();
        this.intervals = new HashMap<String, String>();
        for (Map.Entry<String, String> theEntry : entries.entrySet()) {
            if (theEntry.getKey().contains(LIMITED_INTERVAL_SEPARATOR) || theEntry.getKey().contains(VALUES_SEPARATOR)) {
                this.intervals.put(theEntry.getKey(), theEntry.getValue());
                continue;
            }
            this.directConversion.put(theEntry.getKey(), theEntry.getValue());
        }
    }
}

