/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.translator;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.digitalis.dif.translator.FieldsDictionary;
import pt.digitalis.dif.translator.ITranslatorExporter;
import pt.digitalis.dif.translator.TranslatorMappings;
import pt.digitalis.dif.translator.exception.TranslatorException;
import pt.digitalis.utils.common.IBeanAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorEngine<T> {
    private ITranslatorExporter<T> exporter = null;
    private TranslatorMappings mappings = null;

    public TranslatorEngine(TranslatorMappings mappings, ITranslatorExporter<T> exporter) {
        this.mappings = mappings;
        this.exporter = exporter;
    }

    private void buildMappings(List<? extends IBeanAttributes> listBeans) {
        this.mappings = new TranslatorMappings();
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        FieldsDictionary dictionary = new FieldsDictionary();
        Iterator<? extends IBeanAttributes> i$ = listBeans.iterator();
        while (i$.hasNext()) {
            IBeanAttributes bean;
            IBeanAttributes theClass = bean = i$.next();
            for (Field field : theClass.getClass().getDeclaredFields()) {
                mappingMap.put(field.getName(), field.getName());
            }
        }
        this.mappings.setMappings(mappingMap);
        this.mappings.setFieldsDictionary(dictionary);
    }

    public T execute(List<? extends IBeanAttributes> listBeans) throws TranslatorException {
        if (this.mappings == null) {
            this.buildMappings(listBeans);
        }
        FieldsDictionary fieldsDictionary = this.mappings.getFieldsDictionary();
        this.exporter.init(this.mappings);
        for (IBeanAttributes iBeanAttributes : listBeans) {
            HashMap<String, String> destinationValues = new HashMap<String, String>();
            for (Map.Entry<String, String> mapping : this.mappings.getMappings().entrySet()) {
                String destinationValue;
                String originalValue = iBeanAttributes.getAttributeAsString(mapping.getKey());
                if (fieldsDictionary.fieldHasDictionary(mapping.getKey()).booleanValue()) {
                    destinationValue = fieldsDictionary.getValue(mapping.getKey(), originalValue);
                    if (destinationValue == null && !"".equals(originalValue)) {
                        throw new TranslatorException("Field #key# has dictionary, but now translation for value #value#".replace("#key#", mapping.getKey()).replace("#value#", originalValue));
                    }
                } else {
                    destinationValue = originalValue;
                }
                destinationValues.put(mapping.getValue(), destinationValue);
            }
            this.exporter.processValues(destinationValues);
        }
        this.exporter.terminate();
        return this.exporter.getResult();
    }
}

