/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl.audit.model;

import org.hibernate.cfg.Configuration;

import pt.digitalis.dif.model.utils.AbstractModelManager;

/**
 * The Class DIFAuditDBModelManager.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Jul 19, 2018
 */
public class DIFAuditDBModelManager extends AbstractModelManager {

    /** the model identifier. */
    public static String MODEL_ID = "DIFAuditDBModelManager";

    /**
     * Gets the configuration.
     *
     * @return the configuration
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getConfiguration()
     */
    @Override
    public Configuration getConfiguration()
    {
        return DIFDBAuditFactory.getConfiguration();
    }

    /**
     * Gets the factory name.
     *
     * @return the factory name
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getFactoryName()
     */
    @Override
    public String getFactoryName()
    {
        return DIFDBAuditFactory.SESSION_FACTORY_NAME;
    }

    /**
     * Gets the schema.
     *
     * @return the schema
     * @see pt.digitalis.dif.controller.interfaces.IModelManager#getSchema()
     */
    public String getSchema()
    {
        return "DIF";
    }
}
