/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.ldap;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.ldap.LDAPConfigurations;

public class AttributeConfigurations {
    public static final String BULK_PARAMETER_PROPERTY_KEY = "BulkParameterAttributeName";
    private String bulkParameterAttributeName;
    private Map<String, String> business2LDAPMap = new HashMap<String, String>();
    private Map<String, String> LDAP2BusinessMap = new HashMap<String, String>();

    public AttributeConfigurations() throws ConfigurationException {
        IConfigurations configAPI = (IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
        Properties props = new Properties();
        props = configAPI.readConfiguration("dif2", "IdManagerConfigurations");
        this.bulkParameterAttributeName = props.containsKey(BULK_PARAMETER_PROPERTY_KEY) ? props.getProperty(BULK_PARAMETER_PROPERTY_KEY) : ((LDAPConfigurations)((IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)).readConfiguration(LDAPConfigurations.class)).getBulkParametersAttributeName();
        for (Object key : props.keySet()) {
            if (key.equals(this.bulkParameterAttributeName)) continue;
            this.addMappingPair(key.toString(), props.get(key).toString());
        }
    }

    public void addMappingPair(String businessParameterName, String ldapAttributeName) {
        if (!this.business2LDAPMap.containsKey(businessParameterName) && !this.LDAP2BusinessMap.containsKey(ldapAttributeName)) {
            this.business2LDAPMap.put(businessParameterName, ldapAttributeName);
            this.LDAP2BusinessMap.put(ldapAttributeName, businessParameterName);
        }
    }

    public boolean containsBusinessParameter(String businessParameterName) {
        return this.business2LDAPMap.containsKey(businessParameterName);
    }

    public boolean containsLDAPAttribute(String ldapAttributeName) {
        return this.LDAP2BusinessMap.containsKey(ldapAttributeName);
    }

    public String getBulkParameterAttributeName() {
        return this.bulkParameterAttributeName;
    }

    @ConfigIgnore
    public String getBusiness2LDAPMapping(String businessParameterName) {
        return this.business2LDAPMap.get(businessParameterName);
    }

    @ConfigIgnore
    public String getLDAP2BusinessMapping(String ldapAttributeName) {
        return this.LDAP2BusinessMap.get(ldapAttributeName);
    }

    public void removeMapping(String businessParameterName, String ldapAttributeName) {
        if (this.business2LDAPMap.containsKey(businessParameterName) && this.LDAP2BusinessMap.containsKey(ldapAttributeName)) {
            this.business2LDAPMap.remove(businessParameterName);
            this.LDAP2BusinessMap.remove(ldapAttributeName);
        }
    }

    public void setBulkParameterAttributeName(String bulkParameterAttributeName) {
        this.bulkParameterAttributeName = bulkParameterAttributeName;
    }
}

