/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.impl.AbstractIdentityManager;
import pt.digitalis.dif.controller.security.objects.DIFGroupImpl;
import pt.digitalis.dif.controller.security.objects.DIFUserImpl;
import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPConfigurations;
import pt.digitalis.dif.identity.ldap.IdentityManagerLDAPException;
import pt.digitalis.dif.identity.ldap.LDAPUtilsImplementation;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.Pagination;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ldap.ILDAPUtils;
import pt.digitalis.utils.ldap.LDAPConfigurations;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.LDAPUser;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManagerLDAPImpl
extends AbstractIdentityManager {
    private static IAuthorizationManager authorizationManager = (IAuthorizationManager)DIFIoCRegistry.getRegistry().getImplementation(IAuthorizationManager.class);
    private static String DOMAIN_NAME_USER_ATTRIBUTE = "domainName";
    private static Map<String, String> ldapGroupDNMappingCache = new HashMap<String, String>();
    public static final String NAME = "LDAP";
    private IdentityManagerLDAPConfigurations configurations = null;
    private ILDAPUtils ldapUtils = null;

    public void addGroup(IDIFGroup newGroup) throws IdentityManagerException {
        try {
            LDAPGroup ldapGroup = this.convertFromDIFGroupToLDAPGroup(newGroup);
            this.getLDAPUtils().addGroup(ldapGroup);
            if (ldapGroup != null) {
                ldapGroupDNMappingCache.put(ldapGroup.getDistinguishedName(), newGroup.getID());
            }
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Couldn't add group " + newGroup.getID() + " to LDAP server!", (Exception)((Object)ldapOperationException));
        }
    }

    public void addUser(IDIFUser newUser) throws IdentityManagerException {
        try {
            if (((DIFUserImpl)newUser).getPassword() == null) {
                newUser.setPassword("password");
            }
            this.getLDAPUtils().addUser(this.convertFromDIFUserToLDAPUser(newUser));
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Couldn't add user to LDAP server! " + ldapOperationException.getMessage(), (Exception)((Object)ldapOperationException));
        }
    }

    public void addUserToGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            this.getLDAPUtils().addUserToGroup(groupID, userID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Coud not add user " + userID + " to group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public void changePassword(String userID, String newPassword) throws IdentityManagerException {
        try {
            this.getLDAPUtils().changePassword(userID, newPassword);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not change password for user " + userID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    private LDAPGroup convertFromDIFGroupToLDAPGroup(IDIFGroup difGroup) throws IdentityManagerException {
        LDAPGroup ldapGroup = new LDAPGroup();
        if (difGroup.getID() == null) {
            throw new IdentityManagerLDAPException("Group has no ID! The ID is needed to serve as LDAP cn...");
        }
        ldapGroup.setCommonName(difGroup.getID());
        if (difGroup.getName() != null) {
            ldapGroup.setName(difGroup.getName());
        }
        if (difGroup.getParentGroupID() != null) {
            ldapGroup.setParentGroupDN(this.getParentGroupDNFromProfileID(difGroup.getParentGroupID()));
        }
        if (difGroup.getDescription() != null) {
            ldapGroup.setDescription(difGroup.getDescription());
        }
        return ldapGroup;
    }

    private LDAPUser convertFromDIFUserToLDAPUser(IDIFUser difUser) throws IdentityManagerException {
        LDAPUser ldapUser = new LDAPUser();
        if (difUser.getID() == null) {
            throw new IdentityManagerLDAPException("User has no ID! The ID is needed to serve as LDAP login...");
        }
        ldapUser.setLoginName(difUser.getID());
        ldapUser.setName(difUser.getName());
        ldapUser.setUserName(difUser.getID());
        if (difUser.getProfileID() != null) {
            ldapUser.setParentGroupDN(this.getParentGroupDNFromProfileID(difUser.getProfileID()));
        }
        if (difUser.getNick() != null) {
            ldapUser.setDisplayName(difUser.getNick());
        }
        if (difUser.getName() != null) {
            ldapUser.setGivenName(difUser.getName());
        }
        if (((DIFUserImpl)difUser).getPassword() != null) {
            ldapUser.setPassword(((DIFUserImpl)difUser).getPassword());
        }
        if (difUser.getEmail() != null) {
            ldapUser.setEmail(difUser.getEmail());
        }
        ldapUser.setDescription("DiF2 user");
        CaseInsensitiveHashMap attributes = difUser.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            for (String attributeName : attributes.keySet()) {
                ldapUser.setParameter(attributeName, attributes.get(attributeName).toString());
            }
        }
        for (String attributeName : difUser.getAttributesToRemove()) {
            ldapUser.removeParameter(attributeName);
        }
        return ldapUser;
    }

    private IDIFGroup convertFromLDAPGroupToDIFGroup(LDAPGroup ldapGroup) throws IdentityManagerException {
        DIFGroupImpl difGroup = null;
        if (ldapGroup != null) {
            difGroup = new DIFGroupImpl();
            if (ldapGroup.getCommonName() != null) {
                difGroup.setID(ldapGroup.getCommonName());
            }
            if (ldapGroup.getName() != null) {
                difGroup.setName(ldapGroup.getName());
            }
            difGroup.setParentGroupID("N/A");
            try {
                if (ldapGroup.getParentGroupDN() != null && !ldapGroup.getParentGroupDN().equals("N/A")) {
                    String groupCN = null;
                    if (ldapGroupDNMappingCache.containsKey(ldapGroup.getParentGroupDN())) {
                        groupCN = ldapGroupDNMappingCache.get(ldapGroup.getParentGroupDN());
                    } else {
                        groupCN = this.getLDAPUtils().findGroupByDistinguishedName(ldapGroup.getParentGroupDN()).getCommonName();
                        ldapGroupDNMappingCache.put(ldapGroup.getParentGroupDN(), groupCN);
                    }
                    difGroup.setParentGroupID(groupCN);
                }
            }
            catch (LDAPOperationException ldapOperationException) {
                DIFLogger.getLogger().warn((Object)("Could not access parent group \"" + ldapGroup.getParentGroupDN() + "\", of the group \"" + ldapGroup.getCommonName() + "\"! Exception: " + ldapOperationException.getMessage()));
            }
            if (ldapGroup.getDescription() != null) {
                difGroup.setDescription(ldapGroup.getDescription());
            }
        }
        return difGroup;
    }

    private IDIFUser convertFromLDAPUserToDIFUser(LDAPUser ldapUser) throws IdentityManagerException {
        DIFUserImpl difUser = null;
        if (ldapUser != null) {
            difUser = new DIFUserImpl();
            if (ldapUser.getLoginName() != null) {
                difUser.setID(ldapUser.getLoginName());
            }
            try {
                if (ldapUser.getParentGroupDN() != null && !"N/A".equals(ldapUser.getParentGroupDN())) {
                    if (ldapGroupDNMappingCache.containsKey(ldapUser.getParentGroupDN())) {
                        difUser.setProfileID(ldapGroupDNMappingCache.get(ldapUser.getParentGroupDN()));
                    } else {
                        String profileID = this.convertFromLDAPGroupToDIFGroup(this.getLDAPUtils().findGroupByDistinguishedName(ldapUser.getParentGroupDN())).getID();
                        difUser.setProfileID(profileID);
                        ldapGroupDNMappingCache.put(ldapUser.getParentGroupDN(), profileID);
                    }
                }
            }
            catch (LDAPOperationException profileID) {
                // empty catch block
            }
            if (ldapUser.getLoginName() != null) {
                difUser.setNick(ldapUser.getLoginName());
            }
            if (ldapUser.getGivenName() != null && !ldapUser.getGivenName().equals(this.ldapUtils.getNonAvailableValue())) {
                difUser.setName(ldapUser.getGivenName());
            }
            if (ldapUser.getDisplayName() != null && !ldapUser.getDisplayName().equals(this.ldapUtils.getNonAvailableValue()) && (StringUtils.isBlank((String)difUser.getName()) || difUser.getName().length() < ldapUser.getDisplayName().length())) {
                difUser.setName(ldapUser.getDisplayName());
            }
            if (ldapUser.getPassword() != null) {
                difUser.setPassword(ldapUser.getPassword());
            }
            if (ldapUser.getEmail() != null) {
                difUser.setEmail(ldapUser.getEmail());
            }
            Map parameters = ldapUser.getParameters();
            HashMap<String, String> difAttributes = new HashMap<String, String>();
            difAttributes.putAll(parameters);
            difAttributes.put(DOMAIN_NAME_USER_ATTRIBUTE, ldapUser.getDistinguishedName());
            difUser.initializeAttributes(difAttributes);
        }
        return difUser;
    }

    public int countAllGroups() throws IdentityManagerException {
        try {
            return this.getLDAPUtils().countAllGroups(true);
        }
        catch (LDAPOperationException op) {
            throw new IdentityManagerLDAPException("Could not count all groups: ", (Exception)((Object)op));
        }
        catch (NamingException e) {
            throw new IdentityManagerLDAPException("Could not count all groups: ", e);
        }
    }

    public int countAllGroupsOfUser(String userId) throws IdentityManagerException {
        try {
            int result = 0;
            IDIFUser user = this.getUser(userId);
            if (user.getProfileID() != null) {
                ++result;
            }
            return result += this.getLDAPUtils().countAllGroupsOfUser(userId);
        }
        catch (NamingException ne) {
            throw new IdentityManagerLDAPException("Could not retrieve information for user " + userId + "!", ne);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not retrieve information for user " + userId + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public int countAllUsers() throws IdentityManagerException {
        try {
            return this.getLDAPUtils().countAllUsers();
        }
        catch (LDAPOperationException op) {
            throw new IdentityManagerLDAPException("Could not count all users: ", (Exception)((Object)op));
        }
        catch (NamingException ne) {
            throw new IdentityManagerLDAPException("Could not count all users: ", ne);
        }
    }

    public int countAllUsers(String groupID) throws IdentityManagerException {
        try {
            return this.getLDAPUtils().countAllUsers(groupID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Couldn't add user to LDAP server! " + ldapOperationException.getMessage(), (Exception)((Object)ldapOperationException));
        }
    }

    public int countUsers(Map<String, String> attributes) throws IdentityManagerException {
        try {
            return this.getLDAPUtils().countUsers(attributes);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not retrieve counting for users with attributes " + attributes + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public List<String> gatherManagedAttributes() throws IdentityManagerException {
        LDAPConfigurations ldapconfig;
        try {
            ldapconfig = (LDAPConfigurations)((IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)).readConfiguration(LDAPConfigurations.class);
        }
        catch (ConfigurationException e) {
            throw new IdentityManagerException((Exception)((Object)e));
        }
        try {
            ArrayList<String> result = new ArrayList<String>(ldapconfig.getAttributesMapping().keySet());
            return result;
        }
        catch (ConfigurationException e) {
            throw new IdentityManagerException((Exception)((Object)e));
        }
    }

    public Set<IDIFGroup> getAllGroups() throws IdentityManagerException {
        Set ldapGroups = null;
        HashSet<IDIFGroup> result = null;
        try {
            ldapGroups = this.getLDAPUtils().findAllGroups();
            result = new HashSet<IDIFGroup>();
            for (LDAPGroup g : ldapGroups) {
                result.add(this.convertFromLDAPGroupToDIFGroup(g));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get all groups from LDAP: ", (Exception)((Object)ldapOperationException));
        }
    }

    public Set<IDIFUser> getAllUsers() throws IdentityManagerException {
        Set ldapUsers = null;
        HashSet<IDIFUser> result = null;
        try {
            ldapUsers = this.getLDAPUtils().findAllUsers();
            result = new HashSet<IDIFUser>();
            for (LDAPUser u : ldapUsers) {
                result.add(this.convertFromLDAPUserToDIFUser(u));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get all users from LDAP: ", (Exception)((Object)ldapOperationException));
        }
    }

    protected IdentityManagerLDAPConfigurations getConfigurations() throws IdentityManagerException {
        if (this.configurations == null) {
            try {
                IConfigurations configs = (IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
                this.configurations = (IdentityManagerLDAPConfigurations)configs.readConfiguration(IdentityManagerLDAPConfigurations.class);
            }
            catch (ConfigurationException e) {
                throw new IdentityManagerException((Exception)((Object)e));
            }
        }
        return this.configurations;
    }

    public String getExclusionCharaters() throws IdentityManagerException {
        try {
            return this.getLDAPUtils().getConfigurations().getExclusionCharaters();
        }
        catch (ConfigurationException e) {
            throw new IdentityManagerException((Exception)((Object)e));
        }
    }

    public IDIFGroup getGroup(String groupID) throws IdentityManagerException {
        if (groupID == null || "N/A".equals(groupID)) {
            return null;
        }
        try {
            LDAPGroup ldapGroup = this.getLDAPUtils().findGroupByCommonName(groupID);
            IDIFGroup difGroup = this.convertFromLDAPGroupToDIFGroup(ldapGroup);
            if (difGroup != null) {
                ldapGroupDNMappingCache.put(ldapGroup.getDistinguishedName(), difGroup.getID());
            }
            return difGroup;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not fetch data for group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public String getGroupAttributeName() throws IdentityManagerException {
        return this.getLDAPUtils().getGroupAttributeName();
    }

    public Map<String, IDIFGroup> getGroupGroups(String parentGroupID) throws IdentityManagerException {
        Set childGroups = null;
        try {
            childGroups = this.getLDAPUtils().getChildGroupsByDN(this.getParentGroupDNFromProfileID(parentGroupID));
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not access LDAP server to find child groups of group with ID: " + parentGroupID + "!", (Exception)((Object)ldapOperationException));
        }
        HashMap<String, IDIFGroup> childGroupsMap = new HashMap<String, IDIFGroup>(childGroups.size());
        for (LDAPGroup group : childGroups) {
            IDIFGroup difGroup = this.convertFromLDAPGroupToDIFGroup(group);
            childGroupsMap.put(difGroup.getID(), difGroup);
        }
        return childGroupsMap;
    }

    public Set<IDIFGroup> getGroups(Pagination page) throws IdentityManagerException {
        Set ldapGroups = null;
        HashSet<IDIFGroup> result = null;
        try {
            ldapGroups = this.getLDAPUtils().findGroups(page.getRowsPerPage(), page.getPage());
            result = new HashSet<IDIFGroup>();
            for (LDAPGroup g : ldapGroups) {
                result.add(this.convertFromLDAPGroupToDIFGroup(g));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not retrieve subset of groups (" + page.getRowsPerPage() + " rows per page, " + page.getPage() + " page)", (Exception)((Object)ldapOperationException));
        }
    }

    public Map<String, IDIFUser> getGroupUsers(String groupID) throws IdentityManagerException {
        HashMap<String, IDIFUser> difUsers = new HashMap<String, IDIFUser>();
        Map ldapUsers = null;
        try {
            ldapUsers = this.getLDAPUtils().findUsersInGroup(groupID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException((Exception)((Object)ldapOperationException));
        }
        for (String userID : ldapUsers.keySet()) {
            difUsers.put(userID, this.convertFromLDAPUserToDIFUser((LDAPUser)ldapUsers.get(userID)));
        }
        return difUsers;
    }

    public ILDAPUtils getLDAPUtils() throws IdentityManagerException {
        if (this.ldapUtils == null) {
            if (LDAPUtilsImplementation.AD.equals((Object)this.getConfigurations().getLdapUtilsImplementation())) {
                this.ldapUtils = (ILDAPUtils)DIFIoCRegistry.getRegistry().getImplementation(ILDAPUtils.class, LDAPUtilsImplementation.AD.getIdTag());
            } else if (LDAPUtilsImplementation.OPEN_LDAP.equals((Object)this.getConfigurations().getLdapUtilsImplementation())) {
                this.ldapUtils = (ILDAPUtils)DIFIoCRegistry.getRegistry().getImplementation(ILDAPUtils.class, LDAPUtilsImplementation.OPEN_LDAP.getIdTag());
            } else if (LDAPUtilsImplementation.OID.equals((Object)this.getConfigurations().getLdapUtilsImplementation())) {
                throw new RuntimeException("Oracle OID LDAP Utils implementation is not supported on this version! ");
            }
        }
        this.ldapUtils.setLogger(DIFLogger.getLogger());
        return this.ldapUtils;
    }

    public String getMailAttributeName() throws IdentityManagerException {
        return this.getLDAPUtils().getMailAttributeName();
    }

    public String getNameAttributeName() throws IdentityManagerException {
        return this.getLDAPUtils().getNameAttributeName();
    }

    private final String getParentGroupDNFromProfileID(String profileID) throws IdentityManagerException {
        String result = null;
        try {
            LDAPGroup group = this.getLDAPUtils().findGroupByCommonName(profileID);
            if (group != null) {
                result = group.getDistinguishedName();
            }
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not fetch parent group for profile ID: " + profileID, (Exception)((Object)ldapOperationException));
        }
        return result;
    }

    public IDIFUser getUser(String userID) throws IdentityManagerException {
        try {
            return this.convertFromLDAPUserToDIFUser(this.getLDAPUtils().findUserByLogin(userID));
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not fetch data for user " + userID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public Map<String, IDIFGroup> getUserGroups(String userID) throws IdentityManagerException {
        HashMap<String, IDIFGroup> groupsOfUser = new HashMap<String, IDIFGroup>();
        IDIFGroup difGroup = null;
        try {
            IDIFUser user = this.getUser(userID);
            if (user != null) {
                IDIFGroup profile;
                if (user.getProfileID() != null && (profile = this.getGroup(user.getProfileID())) != null) {
                    groupsOfUser.put(profile.getID(), profile);
                }
                for (LDAPGroup ldapGroup : this.getLDAPUtils().findGroupsOfUser(userID)) {
                    difGroup = this.convertFromLDAPGroupToDIFGroup(ldapGroup);
                    if (difGroup == null) continue;
                    groupsOfUser.put(difGroup.getID(), difGroup);
                    ldapGroupDNMappingCache.put(ldapGroup.getDistinguishedName(), difGroup.getID());
                }
            }
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get groups of user " + userID, (Exception)((Object)ldapOperationException));
        }
        return groupsOfUser;
    }

    public Set<String> getUserGroupsIDs(String userID) throws IdentityManagerException {
        return this.getUserGroups(userID).keySet();
    }

    public Map<String, IDIFGroup> getUserGroupsPagination(String userID, Pagination page) throws IdentityManagerException {
        HashMap<String, IDIFGroup> groupsOfUser = new HashMap<String, IDIFGroup>();
        IDIFGroup difGroup = null;
        try {
            int rowsPerPage = page.getRowsPerPage();
            for (LDAPGroup ldapGroup : this.getLDAPUtils().findGroupsOfUserPagination(userID, Integer.valueOf(rowsPerPage), Integer.valueOf(page.getPage()))) {
                difGroup = this.convertFromLDAPGroupToDIFGroup(ldapGroup);
                if (difGroup == null) continue;
                groupsOfUser.put(difGroup.getID(), difGroup);
                ldapGroupDNMappingCache.put(ldapGroup.getDistinguishedName(), difGroup.getID());
            }
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get groups of user " + userID, (Exception)((Object)ldapOperationException));
        }
        return groupsOfUser;
    }

    public Set<String> getUserIDsInGroup(String groupID) throws IdentityManagerException {
        return this.getGroupUsers(groupID).keySet();
    }

    public String getUserLoginAttributeName() throws IdentityManagerException {
        try {
            return this.getLDAPUtils().getUserLoginAttributeName();
        }
        catch (LDAPOperationException e) {
            throw new IdentityManagerException((Exception)((Object)e));
        }
    }

    public String getUserParentGroupAttributeName() throws IdentityManagerException {
        return this.getLDAPUtils().getUserParentGroupAttributeName();
    }

    public Set<IDIFUser> getUsers(Pagination page) throws IdentityManagerException {
        Set ldapUsers = null;
        HashSet<IDIFUser> result = null;
        try {
            ldapUsers = this.getLDAPUtils().findUsers(page.getRowsPerPage(), page.getPage());
            result = new HashSet<IDIFUser>();
            for (LDAPUser u : ldapUsers) {
                result.add(this.convertFromLDAPUserToDIFUser(u));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get all users from LDAP: ", (Exception)((Object)ldapOperationException));
        }
    }

    public Set<IDIFUser> getUsersByAnyAttribute(Map<String, String> attributes) throws IdentityManagerException {
        return this.internalGetUsersByAttributes(attributes, false);
    }

    public Set<IDIFUser> getUsersByAttribute(String attribute, String value) throws IdentityManagerException {
        value = value.replaceAll("\\%", "*");
        HashSet<IDIFUser> difUsers = new HashSet<IDIFUser>();
        try {
            for (LDAPUser ldapUser : this.getLDAPUtils().findUsersByAttribute(attribute, value)) {
                difUsers.add(this.convertFromLDAPUserToDIFUser(ldapUser));
            }
            return difUsers;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not fetch data for users!", (Exception)((Object)ldapOperationException));
        }
    }

    public Set<IDIFUser> getUsersByAttributes(Map<String, String> attributes) throws IdentityManagerException {
        return this.internalGetUsersByAttributes(attributes, true);
    }

    public Set<IDIFUser> getUsersByAttributes(Map<String, String> attributes, Pagination page) throws IdentityManagerException {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributes.put(entry.getKey(), entry.getValue().replaceAll("\\%", "*"));
        }
        Set ldapUsers = null;
        HashSet<IDIFUser> result = null;
        try {
            ldapUsers = this.getLDAPUtils().findUsersByAttributes(attributes, Integer.valueOf(page.getRowsPerPage()), Integer.valueOf(page.getPage()));
            result = new HashSet<IDIFUser>();
            for (LDAPUser u : ldapUsers) {
                result.add(this.convertFromLDAPUserToDIFUser(u));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get all users from LDAP: ", (Exception)((Object)ldapOperationException));
        }
    }

    public Set<IDIFUser> getUsersByEmail(String value) throws IdentityManagerException {
        return this.getUsersByAttribute(this.getLDAPUtils().getMailAttributeName(), value);
    }

    public boolean groupExists(String groupID) throws IdentityManagerException {
        try {
            return this.getLDAPUtils().groupExists(groupID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not retrieve information for group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    private Set<IDIFUser> internalGetUsersByAttributes(Map<String, String> attributes, boolean allFields) throws IdentityManagerException {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributes.put(entry.getKey(), entry.getValue().replaceAll("\\%", "*"));
        }
        Set ldapUsers = null;
        HashSet<IDIFUser> result = null;
        try {
            ldapUsers = allFields ? this.getLDAPUtils().findUsersByAttributes(attributes) : this.getLDAPUtils().findUsersByAnyAttribute(attributes);
            result = new HashSet<IDIFUser>();
            for (LDAPUser u : ldapUsers) {
                result.add(this.convertFromLDAPUserToDIFUser(u));
            }
            return result;
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not get all users from LDAP: ", (Exception)((Object)ldapOperationException));
        }
    }

    public boolean isIdentityValid(String userID, String suppliedPassword) throws IdentityManagerException {
        try {
            return this.getLDAPUtils().isIdentityValid(userID, suppliedPassword);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not verify identity of user " + userID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public boolean isReadOnly() throws IdentityManagerException {
        try {
            return this.getLDAPUtils().isReadOnly();
        }
        catch (LDAPOperationException e) {
            throw new IdentityManagerException((Exception)((Object)e));
        }
    }

    public boolean isSaveParameterValuesOnlyIfEmpty() throws IdentityManagerException, ConfigurationException {
        return this.getLDAPUtils().getConfigurations().getSaveParameterValuesOnlyIfEmpty();
    }

    public boolean isUserInGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            return this.getLDAPUtils().isUserInGroup(groupID, userID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not check if user " + userID + " belongs to group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public synchronized void persistUserAttribute(String userID, String attributeID, Object attributeValue) throws IdentityManagerException {
        if (!DOMAIN_NAME_USER_ATTRIBUTE.equals(attributeID)) {
            try {
                this.getLDAPUtils().setUserAttribute(userID, attributeID, (Object)attributeValue.toString());
            }
            catch (LDAPOperationException ldapOperationException) {
                throw new IdentityManagerLDAPException("Could not update attribute with ID: " + attributeID + " with value : " + attributeValue + " for user with ID: " + userID + "!", (Exception)((Object)ldapOperationException));
            }
        }
    }

    public void persistUserAttributes(String userID, Map<String, Object> attributes) throws IdentityManagerException {
        for (String attributeID : attributes.keySet()) {
            this.updateUserAttribute(userID, attributeID, attributes.get(attributeID));
        }
    }

    public void removeGroup(String groupID) throws IdentityManagerException {
        try {
            LDAPGroup ldapGroup = this.getLDAPUtils().findGroupByCommonName(groupID);
            if (ldapGroup != null) {
                this.getLDAPUtils().removeGroup(groupID);
                authorizationManager.revokeAllAccessFromGroup(groupID);
                ldapGroupDNMappingCache.remove(ldapGroup.getDistinguishedName());
            }
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not remove group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public void removeUser(String userID) throws IdentityManagerException {
        try {
            this.getLDAPUtils().removeUser(userID);
            authorizationManager.revokeAllAccessFromUser(userID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not remove user " + userID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public void removeUserFromGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            this.getLDAPUtils().removeUserFromGroup(groupID, userID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not remove user " + userID + " from group " + groupID + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public void resetIdentityManager() {
        if (this.ldapUtils != null) {
            this.ldapUtils.resetConfigurations();
        }
        this.configurations = null;
        this.ldapUtils = null;
    }

    public void updateGroup(IDIFGroup existingGroup) throws IdentityManagerException, ConfigurationException {
        try {
            this.getLDAPUtils().updateGroup(this.convertFromDIFGroupToLDAPGroup(existingGroup), existingGroup.getID());
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not update group " + existingGroup.getID() + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public void updateUser(IDIFUser existingUser, String userID) throws IdentityManagerException {
        try {
            existingUser.cleanCache();
            this.getLDAPUtils().updateUser(this.convertFromDIFUserToLDAPUser(existingUser), userID);
            existingUser.refresh();
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not update user " + existingUser.getID() + "!", (Exception)((Object)ldapOperationException));
        }
    }

    public synchronized void updateUserAttribute(String userID, String attributeID, Object attributeValue) throws IdentityManagerException {
        this.persistUserAttribute(userID, attributeID, attributeValue);
    }

    public synchronized void updateUserAttributes(String userID, Map<String, Object> attributes) throws IdentityManagerException {
        this.persistUserAttributes(userID, attributes);
    }

    public boolean userExists(String userID) throws IdentityManagerException {
        try {
            return userID == null ? false : this.getLDAPUtils().userExists(userID);
        }
        catch (LDAPOperationException ldapOperationException) {
            throw new IdentityManagerLDAPException("Could not retrieve information for user " + userID + "!", (Exception)((Object)ldapOperationException));
        }
    }
}

