/**
 *
 */
package util;

/**
 * @author pviegas
 */
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

// TODO: Auto-generated Javadoc
/**
 * The Class BrowserInfo.
 */
@SuppressWarnings("serial")
public class BrowserInfo extends HttpServlet {

    /** The company. */
    protected String company;

    /** The language. */
    protected String language = "pt";

    /** The locale. */
    protected Locale locale;

    /** The main version. */
    protected String mainVersion;

    /** The minor version. */
    protected String minorVersion;

    /** The name. */
    protected String name;

    /** The os. */
    protected String os;

    /** The request. */
    protected HttpServletRequest request;

    /** The supported languages. */
    private Hashtable<String, String> supportedLanguages;

    /** The user agent. */
    protected String userAgent;

    /** The version. */
    protected String version;

    /**
     * Instantiates a new browser info.
     * 
     * @param request
     *            the request
     */
    public BrowserInfo(HttpServletRequest request)
    {
        this.initialize();
        this.request = request;

        this.setUserAgent(this.request.getHeader("User-Agent"));
        this.setCompany();
        this.setName();
        this.setVersion();
        this.setMainVersion();
        this.setMinorVersion();
        this.setOs();
        this.setLanguage();
        this.setLocale();
    }

    /**
     * Gets the chrome version.
     * 
     * @return the Google Chrome version
     */
    private String getChromeVersion()
    {
        int pos = (userAgent.indexOf("chrome") + "chrome".length());
        int pos2 = this.userAgent.indexOf("/", pos) + 1;
        int pos3 = this.userAgent.indexOf(" ", pos2);
        return this.userAgent.substring(pos2, pos3);
    }

    /**
     * Gets the company.
     * 
     * @return the company
     */
    public String getCompany()
    {
        return this.company;
    }

    /**
     * Gets the fF version.
     * 
     * @return the fF version
     */
    private String getFFVersion()
    {
        int pos = (userAgent.indexOf("firefox") + "firefox".length());
        int pos2 = this.userAgent.indexOf("/", pos) + "/".length();
        return this.userAgent.substring(pos2, this.userAgent.length());
    }

    /**
     * Gets the language.
     * 
     * @return the language
     */
    public String getLanguage()
    {
        return this.language;
    }

    /**
     * Gets the locale.
     * 
     * @return the locale
     */
    public Locale getLocale()
    {
        return this.locale;
    }

    /**
     * Gets the main version.
     * 
     * @return the main version
     */
    public String getMainVersion()
    {
        return this.mainVersion;
    }

    /**
     * Gets the minor version.
     * 
     * @return the minor version
     */
    public String getMinorVersion()
    {
        return this.minorVersion;
    }

    /**
     * Gets the name.
     * 
     * @return the name
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Gets the os.
     * 
     * @return the os
     */
    public String getOs()
    {
        return this.os;
    }

    /**
     * Gets the safari version.
     * 
     * @return the Safari version
     */
    private String getSafariVersion()
    {
        int pos = (userAgent.indexOf("version") + "version".length());
        int pos2 = this.userAgent.indexOf("/", pos) + 1;
        int pos3 = this.userAgent.indexOf(" ", pos2);
        return this.userAgent.substring(pos2, pos3);
    }

    /**
     * Gets the version.
     * 
     * @return the version
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * Initialize.
     */
    public void initialize()
    {
        this.supportedLanguages = new Hashtable<String, String>(2);

        this.supportedLanguages.put("en", "");
        this.supportedLanguages.put("pt", "");
    }

    /**
     * Checks if is chrome.
     * 
     * @return true, if is chrome
     */
    public boolean isChrome()
    {
        return ("Netscape Communications".equals(getCompany()) && userAgent.contains("chrome"));
    }

    /**
     * Checks if is chrome7 more.
     * 
     * @return true, if is chrome7 more
     */
    private boolean isChrome7More()
    {
        if (isChrome())
        {
            try
            {
                String version = this.getVersion();
                String versao = version.substring(0, version.indexOf("."));
                Integer verInt = new Integer(versao);
                return verInt >= 3;
            }
            catch (NumberFormatException e)
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    /**
     * Checks if is fF.
     * 
     * @return true, if is fF
     */
    public boolean isFF()
    {
        return ("Netscape Communications".equals(getCompany()) && userAgent.contains("firefox"));
    }

    /**
     * Checks if is f f3 more.
     * 
     * @return true, if is f f3 more
     */
    public boolean isFF3More()
    {
        if (isFF())
        {
            try
            {
                String version = this.getVersion();
                String versao = version.substring(0, version.indexOf("."));
                Integer verInt = new Integer(versao);
                return verInt >= 3;
            }
            catch (NumberFormatException e)
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    /**
     * Checks if is iE.
     * 
     * @return true, if is iE
     */
    public boolean isIE()
    {
        return ("Microsoft".equals(getCompany()));
    }

    /**
     * Checks if is i e6.
     * 
     * @return true, if is i e6
     */
    public boolean isIE6()
    {
        try
        {
            return (isIE() && (Integer.parseInt(getMainVersion()) == 6));
        }
        catch (NumberFormatException e)
        {
            return false;
        }
    }

    /**
     * Checks if is i e7.
     * 
     * @return true, if is i e7
     */
    public boolean isIE7()
    {
        try
        {
            return (isIE() && (Integer.parseInt(getMainVersion()) == 7));
        }
        catch (NumberFormatException e)
        {
            return false;
        }
    }

    /**
     * Checks if is i e7 more.
     * 
     * @return true, if is i e7 more
     */
    public boolean isIE7More()
    {
        if (isIE())
        {
            try
            {
                String version = this.getVersion();
                String versao = version.substring(0, version.indexOf("."));
                Integer verInt = new Integer(versao);
                return (verInt >= 7);
            }
            catch (NumberFormatException e)
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    /**
     * Checks if is i e8.
     * 
     * @return true, if is i e8
     */
    public boolean isIE8()
    {
        try
        {
            return (isIE() && (Integer.parseInt(getMainVersion()) == 8));
        }
        catch (NumberFormatException e)
        {
            return false;
        }
    }

    /**
     * Checks if is safari.
     * 
     * @return T if the browser is Safari
     */
    public boolean isSafari()
    {
        return ("Netscape Communications".equals(getCompany()) && userAgent.contains("safari"));
    }

    /**
     * Checks if is safari5 more.
     * 
     * @return if the browser is safari 5 or upper
     */
    private boolean isSafari5More()
    {
        if (isSafari())
        {
            try
            {
                String version = this.getVersion();
                String versao = version.substring(0, version.indexOf("."));
                Integer verInt = new Integer(versao);
                return verInt >= 5;
            }
            catch (NumberFormatException e)
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    /**
     * Checks if is supported browser.
     * 
     * @return true, if is supported browser
     */
    public boolean isSupportedBrowser()
    {
        return (isIE7More() || isFF3More() || isChrome7More() || isSafari5More());
    }

    /**
     * Parses the locale.
     * 
     * @param language
     *            the language
     * @return the string
     */
    private String parseLocale(String language)
    {
        StringTokenizer st = new StringTokenizer(language, "-");

        if (st.countTokens() == 2)
        {
            return st.nextToken();
        }
        else
        {
            return language;
        }
    }

    /**
     * Sets the company.
     */
    private void setCompany()
    {
        if (this.userAgent.indexOf("opera") > -1)
        {
            this.company = "Opera Software";
        }
        else if (this.userAgent.indexOf("msie") > -1)
        {
            this.company = "Microsoft";
        }
        else if (this.userAgent.indexOf("mozilla") > -1)
        {
            this.company = "Netscape Communications";
        }
        else if (this.userAgent.indexOf("Chrome") > -1)
        {
            this.company = "Google";
        }
        else if (this.userAgent.indexOf("safari") > -1)
        {
            this.company = "Apple";
        }
        else
        {
            this.company = "unknown";
        }
    }

    /**
     * Sets the language.
     */
    private void setLanguage()
    {
        String prefLanguage = this.request.getHeader("Accept-Language");

        if (prefLanguage != null)
        {
            String language = null;
            StringTokenizer st = new StringTokenizer(prefLanguage, ",");

            int elements = st.countTokens();

            for (int idx = 0; idx < elements; idx++)
            {
                if (this.supportedLanguages.containsKey((language = st.nextToken())))
                {
                    this.language = this.parseLocale(language);
                }
            }
        }
    }

    /**
     * Sets the locale.
     */
    private void setLocale()
    {
        this.locale = new Locale(this.language, "");
    }

    /**
     * Sets the main version.
     */
    private void setMainVersion()
    {
        try
        {
            this.mainVersion = this.version.substring(0, this.version.indexOf("."));
        }
        catch (StringIndexOutOfBoundsException e)
        {
            this.mainVersion = null;
        }
    }

    /**
     * Sets the minor version.
     */
    private void setMinorVersion()
    {
        try
        {
            this.minorVersion = this.version.substring(this.version.indexOf(".") + 1).trim();
        }
        catch (StringIndexOutOfBoundsException e)
        {
            this.minorVersion = null;
        }

    }

    /**
     * Sets the name.
     */
    private void setName()
    {
        if (this.company == "Microsoft")
            this.name = "Microsoft Internet Explorer";
        else if (this.company == "Netscape Communications")
        {
            if (isFF())
                this.name = "Firefox";
            else if (isChrome())
                this.name = "Chrome";
            else if (isSafari())
                this.name = "Safari";
            else
                this.name = "Netscape Navigator";
        }
        else if (this.company == "Operasoftware")
            this.name = "Operasoftware Opera";
        else
            this.name = "unknown";
    }

    /**
     * Sets the os.
     */
    private void setOs()
    {
        if (this.userAgent.indexOf("win") > -1)
        {
            if (this.userAgent.indexOf("windows 95") > -1 || this.userAgent.indexOf("win95") > -1)
            {
                this.os = "Windows 95";
            }
            else if (this.userAgent.indexOf("windows 98") > -1 || this.userAgent.indexOf("win98") > -1)
            {
                this.os = "Windows 98";
            }
            else if (this.userAgent.indexOf("windows nt") > -1 || this.userAgent.indexOf("winnt") > -1)
            {
                this.os = "Windows NT";
            }
            else if (this.userAgent.indexOf("win16") > -1 || this.userAgent.indexOf("windows 3.") > -1)
            {
                this.os = "Windows 3.x";
            }

        }
        else if (this.userAgent.indexOf("Mac") > -1)
        {
            if (this.userAgent.indexOf("Mac_PowerPC") > -1 || this.userAgent.indexOf("Mac_PPC") > -1)
            {
                this.os = "Macintosh Power PC";
            }
            else if (this.userAgent.indexOf("Macintosh") > -1)
            {
                this.os = "Macintosh";
            }
            else
            {
                this.os = "Unknown Mac";
            }
        }
    }

    /**
     * Sets the user agent.
     * 
     * @param httpUserAgent
     *            the new user agent
     */
    public void setUserAgent(String httpUserAgent)
    {
        this.userAgent = httpUserAgent.toLowerCase();
    }

    /**
     * Sets the version.
     */
    private void setVersion()
    {
        int tmpPos;
        String tmpString;

        if (this.company == "Microsoft")
        {
            String str = this.userAgent.substring(this.userAgent.indexOf("msie") + 5);
            this.version = str.substring(0, str.indexOf(";"));
        }
        else if (isFF())
            this.version = getFFVersion();

        else if (isChrome())
            this.version = getChromeVersion();

        else if (isSafari())
            this.version = getSafariVersion();

        else
        {
            tmpString = (this.userAgent.substring(tmpPos = (this.userAgent.indexOf("/")) + 1, tmpPos
                    + this.userAgent.indexOf(" "))).trim();
            this.version = tmpString.substring(0, tmpString.indexOf(" "));
        }
    }
}