/*
 * Created on 17/Nov/2004 TODO To change the template for this generated file go to Window - Preferences - Java - Code
 * Style - Code Templates
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

// TODO: Auto-generated Javadoc
/**
 * The Class ByteStream.
 */
public class ByteStream {

    /**
     * To byte array.
     * 
     * @param ins
     *            the ins
     * @param an_int
     *            the an_int
     * @return the byte[]
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     * @throws Exception
     *             the exception
     */
    @SuppressWarnings("unused")
    private static byte[] toByteArray(InputStream ins, int an_int) throws java.io.IOException, Exception
    {

        byte[] ret = new byte[an_int];

        int offset = 0;
        int numRead = 0;
        int outstanding = an_int;

        while ((offset < an_int) && ((numRead = ins.read(ret, offset, outstanding)) > 0))
        {
            offset += numRead;
            outstanding = an_int - offset;
        }
        if (offset < ret.length)
        {
            throw new Exception("Could not completely read from stream, numRead=" + numRead + ", ret.length="
                    + ret.length); // ???
        }
        return ret;
    }

    /**
     * To byte array.
     * 
     * @param in_int
     *            the in_int
     * @return the byte[]
     */
    private static byte[] toByteArray(int in_int)
    {
        byte a[] = new byte[4];
        for (int i = 0; i < 4; i++)
        {

            int b_int = (in_int >> (i * 8)) & 255;
            byte b = (byte) (b_int);

            a[i] = b;
        }
        return a;
    }

    /**
     * To file.
     * 
     * @param ins
     *            the ins
     * @param file
     *            the file
     * @throws FileNotFoundException
     *             the file not found exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static void toFile(InputStream ins, File file) throws java.io.FileNotFoundException, java.io.IOException
    {

        int len = toInt(ins);
        toFile(ins, file, len);
    }

    /**
     * To file.
     * 
     * @param ins
     *            the ins
     * @param file
     *            the file
     * @param len
     *            the len
     * @throws FileNotFoundException
     *             the file not found exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    private static void toFile(InputStream ins, File file, int len) throws java.io.FileNotFoundException,
            java.io.IOException
    {

        FileOutputStream fos = new FileOutputStream(file);

        toFile(ins, fos, len, 1024);
    }

    /**
     * To file.
     * 
     * @param ins
     *            the ins
     * @param fos
     *            the fos
     * @param len
     *            the len
     * @param buf_size
     *            the buf_size
     * @throws FileNotFoundException
     *             the file not found exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    private static void toFile(InputStream ins, FileOutputStream fos, int len, int buf_size)
            throws java.io.FileNotFoundException, java.io.IOException
    {

        byte[] buffer = new byte[buf_size];

        int len_read = 0;
        int total_len_read = 0;

        while (total_len_read + buf_size <= len)
        {
            len_read = ins.read(buffer);
            total_len_read += len_read;
            System.out.print(len_read);
            fos.write(buffer, 0, len_read);
        }

        if (total_len_read < len)
        {
            toFile(ins, fos, len - total_len_read, buf_size / 2);
        }
    }

    /**
     * To int.
     * 
     * @param byte_array_4
     *            the byte_array_4
     * @return the int
     */
    private static int toInt(byte[] byte_array_4)
    {
        int ret = 0;
        for (int i = 0; i < 4; i++)
        {
            int b = byte_array_4[i];
            if (i < 3 && b < 0)
            {
                b = 256 + b;
            }
            ret += b << (i * 8);
        }
        return ret;
    }

    /**
     * To int.
     * 
     * @param in
     *            the in
     * @return the int
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static int toInt(InputStream in) throws java.io.IOException
    {
        byte[] byte_array_4 = new byte[4];

        byte_array_4[0] = (byte) in.read();
        byte_array_4[1] = (byte) in.read();
        byte_array_4[2] = (byte) in.read();
        byte_array_4[3] = (byte) in.read();

        return toInt(byte_array_4);
    }

    /**
     * To stream.
     * 
     * @param os
     *            the os
     * @param file
     *            the file
     * @throws FileNotFoundException
     *             the file not found exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static void toStream(OutputStream os, File file) throws java.io.FileNotFoundException, java.io.IOException
    {

        toStream(os, (int) file.length());

        byte b[] = new byte[1024];
        InputStream is = new FileInputStream(file);
        int numRead = 0;

        while ((numRead = is.read(b)) > 0)
        {
            os.write(b, 0, numRead);
        }
        os.flush();
    }

    /**
     * To stream.
     * 
     * @param os
     *            the os
     * @param i
     *            the i
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static void toStream(OutputStream os, int i) throws java.io.IOException
    {
        byte[] byte_array_4 = toByteArray(i);
        os.write(byte_array_4);
    }

    /**
     * To stream.
     * 
     * @param os
     *            the os
     * @param s
     *            the s
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static void toStream(OutputStream os, String s) throws java.io.IOException
    {
        int len_s = s.length();
        toStream(os, len_s);
        for (int i = 0; i < len_s; i++)
        {
            os.write((byte) s.charAt(i));
        }
        os.flush();
    }

    /**
     * To string.
     * 
     * @param ins
     *            the ins
     * @return the string
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static String toString(InputStream ins) throws java.io.IOException
    {
        int len = toInt(ins);
        return toString(ins, len);
    }

    /**
     * To string.
     * 
     * @param ins
     *            the ins
     * @param len
     *            the len
     * @return the string
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    private static String toString(InputStream ins, int len) throws java.io.IOException
    {
        String ret = new String();
        for (int i = 0; i < len; i++)
        {
            ret += (char) ins.read();
        }
        return ret;
    }
}