/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 *
 */

package util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import util.dateutils.DateConverter;

// TODO: Auto-generated Javadoc
/**
 * Set of generic utility methods.
 * <p>
 * <b>NOTE</b> : Usage of this class methods should be avoided at all costs. It'll be discontinued in future releases.
 *
 * @author Ricardo Correia de Oliveira <a href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 *
 */
public class CommonFunctions {

	/**
	* Common string find & replace method.
	*
	* @param data to change
	* @param find value to find
	* @param replace value for replacement
	* @return updated data
	*/
	public static String findReplace(String data, String find, String replace) {
		StringBuffer sb = new StringBuffer();
		int cursor = 0;
		int finder;
		int findLength = find.length();

		while((finder = data.indexOf(find,cursor)) != -1) {
			sb.append(data.substring(cursor,finder));
			sb.append(replace);
			cursor = finder + findLength;
		}

		if(cursor < data.length()) {
			sb.append(data.substring(cursor));
		}

		return sb.toString();
	 }

	/**
	 * Parses the data aux.
	 *
	 * @param dateValue the date value
	 * @return the string
	 */
	public static String parseDataAux(String dateValue) {
        try {
            DateConverter.stringToDate(dateValue , DateConverter.DATE_FORMAT1);
            if (dateValue.equals("0-0-0"))
            	dateValue  = "";
         }catch (ParseException e) {
        	 dateValue = "";
         }
         return dateValue ;
    }

    /**
     * Parses the date from request.
     *
     * @param params the params
     * @param attName the att name
     * @return the string
     */
    public static String parseDateFromRequest(HashMap<String,?> params, String attName) {
        String attData = params.get(attName+"_dia") + "-" + params.get(attName+"_mes") + "-" + params.get(attName+"_ano");
        return parseDataAux(attData);
    }

    /**
     * Parses the date from request.
     *
     * @param req the req
     * @param attName the att name
     * @return the string
     */
    public static String parseDateFromRequest(HttpServletRequest req,String attName){
        String attData = req.getAttribute(attName+"_dia") + "-" + req.getAttribute(attName+"_mes") + "-" + req.getAttribute(attName+"_ano");
        return parseDataAux(attData);
    }

    /**
	* Finds out if some string value is present in a ArrayList.
	*
	* @param list list to find data from
	* @param value value to search
	* @param ignoreCase ignore case in comparison
	* @return true/false
	*/
	public static boolean searchIn(ArrayList<?> list, String value, boolean ignoreCase) {
		if (ignoreCase) {
			for (int i=0; i < list.size(); i++ ) {
				if (list.get(i).toString().equalsIgnoreCase(value))	{
					return true;
				}
			}
		}
		else {
			for (int i=0; i < list.size(); i++ ) {
				if (list.get(i).toString().equals(value))	{
					return true;
				}
			}
		}

		return false;
	}


}
