/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package util;
// TODO: Auto-generated Javadoc
/**
 * Base class used to process condition expressions.
 * Only process two arguments condition.
 *<p>
 * The available comparations are :
 * <blockquote><pre>
 *   == -> values must be exactly equal;<br />
 *   != -> values must be diferent;<br />
 *   <= -> first argument must be lower or equal to the second (comparation as String);<br />
 *   >= -> first argument must be higher or equal to the second (comparation as String);<br />
 *   >  -> first argument must be higher than the second (comparation as String);<br />
 *   <  -> first argument must be lower than to the second  (comparation as String);<br />
 *   LIKE -> values must be exactly equal, case insensitive comparation;<br />
 * </pre></blockquote>
 * 
 * @author Ricardo Correia de Oliveira <a href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 */
public abstract class Condition {

	/**
	 * Constant used to specify the first argument.
	 */
	protected final static char FIRST_ARG = 'F';
	/**
	 * Constant used to specify the second argument.
	 */
	protected final static char SECOND_ARG = 'S';

	/**
	 * Evaluates an expression.
	 * Only suports two arguments
	 *  
	 * @param word  the condition to check
	 * @return <code>true</code> if the expressions evaluate to <code>true</code> 
	 */
	public boolean eval(String word){
		// Obtem a expresso actual
		String exp = this.getExpression(word);
		// Obtem o 1 argumento da expresso
		String arg1 = this.getArg(exp, FIRST_ARG);
		// Obtem o 2 argumento da expresso
		String arg2 = this.getArg(exp, SECOND_ARG);
		// Obtem o operador da expresso
		String oper = this.getOperator(exp);
		// Executa a condio 
		return this.execute(arg1, arg2, oper);
	}

	/**
	 * Executes the comparation between two arguments with the specified operator.
	 * @param arg1 the first argument
	 * @param arg2 the second argument
	 * @param oper the conditional operator
	 * @return <code>true</code> if the comparation evaluate to <code>true</code>
	 */
	protected boolean execute(String arg1, String arg2, String oper){
		boolean res = false;
		/**
		 * Checks which operation is to be executed and executs it
		 * Throws a RuntimeException if the operation is unknown
		 */
		if(oper.equals("==")){
			res = arg1.equals(arg2);
		} else if(oper.equals("!=")){
			res = !arg1.equals(arg2);
		} else if(oper.equals("<=")){
			res = (arg1.compareTo(arg2)<=0);
		} else if(oper.equals(">=")){
			res = (arg1.compareTo(arg2)>=0);
		} else if(oper.equals(">")){
			res = (arg1.compareTo(arg2)>0);
		} else if(oper.equals("<")){
			res = (arg1.compareTo(arg2)<0);
		} else if(oper.toUpperCase().equals("LIKE")){
			res = arg1.toLowerCase().equals(arg2.toLowerCase());
		}else{
			//System.out.print("[Condition.execute] Unkown operation in "+this.getClass().getName()+".execute("+arg1+","+arg2+","+oper+")");
			throw new RuntimeException("Unkown operation in "+this.getClass().getName()+".execute("+arg1+","+arg2+","+oper+")");
		}
		//System.out.print("[Condition.execute] Action : "+arg1+" "+oper+" "+arg2+" = "+res);
		return res;
	}

	/**
	 * Gets a argument from a expression.
	 * @param exp    the expression to get the argument from
	 * @param argNum specifies which argument is to retreave, first or second
	 * @return the argument
	 */
	protected String getArg(String exp, char argNum){
		String arg;
		// Obtem o valor do argumento pedido
		if(argNum == FIRST_ARG){ arg = exp.substring(0, this.getIndexOfOperStart(exp));
		}else{ arg = exp.substring(this.getIndexOfOperEnd(exp)); }
		// Remove os espaos do argumento
		return this.stripSpaces( arg);
	}

	/**
	 * Gets the expression to evaluate.
	 * @param exp the expression to evaluate
	 * @return the expression
	 */
	protected String getExpression(String exp){
		return exp;
	}

	/**
	 * Gets the last index of the operator.
	 * @param exp the expression to get the index from
	 * @return the last index of the operator
	 */
	protected int getIndexOfOperEnd(String exp){
		int ind;
		if((ind = exp.indexOf('!'))!=-1){
			ind+=2; 															// !=
		}else if((ind = exp.indexOf('<'))!=-1){
			if(exp.indexOf('=', ind)!=-1) ind+=2; // <=
			else ind+=1;													// <
		}else if((ind = exp.indexOf('>'))!=-1){
			if(exp.indexOf('=', ind)!=-1) ind+=2;	// >=
			else ind+=1;													// >
		}else if((ind = exp.indexOf('='))!=-1){
				ind+=2;															// ==
		}else if((ind = exp.indexOf("LIKE"))!=-1){
			return ind+=4;												// LIKE
		}
		return ind;
	}

	/**
	 * Gets the starting index of the operator.
	 * @param exp the expression to get the index from
	 * @return the initial index of the operator
	 */
	protected int getIndexOfOperStart(String exp){
		int ind;
		if((ind = exp.indexOf('!'))==-1){
			if((ind = exp.indexOf('<'))==-1){
				if((ind = exp.indexOf('>'))==-1){
					if((ind = exp.indexOf('='))==-1){ // Tem de ser o ultimo pq poder combinar com os operadores anteriores
						ind = exp.indexOf("LIKE");
					}
				}
			}
		}
		return ind;
	}

	/**
	 * Gets the operator of the expression.
	 * @param exp the expression to get the operator from
	 * @return the operator
	 */
	protected String getOperator(String exp){
		return exp.substring(this.getIndexOfOperStart(exp), this.getIndexOfOperEnd(exp));
	}

	/**
	 * Checks if the value of a String is numerical.
	 * @param value the value o check
	 * @return true if the value representation of the String is numerical
	 */
	protected boolean isNumeric(String value){
		try {
			Double.parseDouble(value);
			return true;
		} catch(NumberFormatException nfe){
			return false;
		}
	}

	/**
	 * Removes the whitespace if the argument is numerical.
	 * @param value the value to remove the whitespace from
	 * @return a free whitespace string if the value is numerical, otherwise, exactly equal to the inicial string value
	 */
	protected String stripSpaces(String value){
		StringBuffer res = null;
		// Verifica se  numero
		if(isNumeric(value)){
			// Remove os espaos existentes na String
			res = new StringBuffer();
			for(int i=0;i<value.length();i++){
				if(value.charAt(i) != ' '){
					res.append( value.charAt(i));
				}
			}
		}else{
			res = new StringBuffer( value);
		}
		return res.toString();
	}
}