/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package util;

import javax.xml.transform.TransformerException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import util.xml.XMLUtil;


// TODO: Auto-generated Javadoc
/**
 * Condition implementation class that accepts arguments as being defined as XPath arguments.
 * The XPath argument is processed against the XML and it's corresponding value used on the comparation.
 * 
 * @author Ricardo Correia de Oliveira <a href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * Created on Feb 9, 2004
 */
public class ConditionXPath extends util.Condition{
	/**
	 * The node to use as context node, base node for relative XPath.
	 */
	private Node node = null;

	/**
	 * Creates a XPath condition instance.
	 * The XML node will be used to get the XPath value.
	 * @param _node the node to use as context node, base node for relative XPath
	 */
	public ConditionXPath(Node _node){
		this.node = _node;
	}
	
	/**
	 * Gets a argument from a expression.
	 * If it's a XPath then processes it to get the correponding value
	 * @param exp    the expression to get the argument from
	 * @param pos specifies which argument is to retreave, first or second
	 * @return the argument
	 * 
	 */
	protected String getArg(String exp, char pos){
		String arg = super.getArg( exp, pos);
		// Verifica se ? XPath
		if(isXPathArg( arg)){
			// Efectua o parse do XPath sobre o documento para obter o valor
			arg = this.getXPathValue( arg);
		}
		//System.out.print("[ConditionXPath] getArg("+exp+", "+pos+") : arg = "+arg);
		return arg; 
	}


	/**
	 * Gets the operator of the expression.
	 * @param exp the expression to get the operator from
	 * @return the operator
	 */
	protected String getOperator(String exp){
		return super.getOperator(exp);
	}

	/**
	 * Process a XPath over the XML specified for this instance.
	 * @param arg the XPath
	 * @return the value representation of the the XPath on the XML
	 */
	protected String getXPathValue(String arg){
		Node resNode = null;
		try {
			//System.out.print("arg = "+arg);
			resNode = XMLUtil.getNode(this.node, arg);
			if(resNode==null){
				if(XMLUtil.countElements( this.node, arg) > 0){
					resNode = XMLUtil.getNode( this.node, arg+"[1]");
				}
			}
		} catch (TransformerException e) {
			e.printStackTrace();
		}
		String value = null;
		if(resNode!=null){
			if(resNode instanceof Element){
				value = resNode.getNodeName();
			} else {
				value = resNode.getNodeValue();
			}
		}
		return ((value==null)?"null":value);
	}

	/**
	 * Checks if an argument is XPath. 
	 * @param arg teh argument to check if it's XPath
	 * @return true if the argument is a XPath argument
	 * TODO : Implemntar uma forma de verifica??o mais completa
	 */
	protected boolean isXPathArg(String arg){
		return ((arg.length()>0)? (arg.charAt(0)=='/') : false);
	}
}