/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util;

import java.text.DecimalFormat;
import java.util.Random;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the manipulation/validation of numbers.
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * Created on 17/Nov/2004
 */
public class NumberUtil {
	/**
	 * Formats a numeric value to a currency value.
	 *
	 * @param _value the value to be formated
	 * @return the formated value
	 */
	public static String formatCurrency(Double _value) {
		DecimalFormat format = (DecimalFormat) DecimalFormat.getInstance();
		format.setMaximumFractionDigits(2);
		format.setMinimumFractionDigits(2);
		format.setGroupingUsed(true);
		format.getDecimalFormatSymbols().setGroupingSeparator(',');
		format.getDecimalFormatSymbols().setDecimalSeparator('.');
		return format.format(_value);
	}

	/**
	 * Formats a string to a currency value.
	 *
	 * @param _value the value to be formated
	 * @return the formated value
	 * @throws NumberFormatException if the value can't be converted to a number
	 */
	public static String formatCurrency(String _value) throws NumberFormatException {
		String value = _value.replaceAll(",", ".");
		return formatCurrency(Double.valueOf(value));
	}

	/**
	 * Generate a single random integer between aLowerLimit
	 * and aUpperLimit, inclusive.
	 * 
	 * Important: if this method is called twice in rapid succession, it will
	 * return the same value.
	 *
	 * @param aLowerLimit the a lower limit
	 * @param aUpperLimit the a upper limit
	 * @return the int
	 */
    	public static int generateRandom(int aLowerLimit, int aUpperLimit ) {
        Random generator = new Random();
        // get the range, casting to long to avoid overflow problems
        long range = (long)aUpperLimit - (long)aLowerLimit + 1;
        // compute a fraction of the range, 0 <= frac < range
        long fraction = (long)(range * generator.nextDouble());
        return (int)(fraction + aLowerLimit);
    	}

	/**
	 * Checks if it's an arabic digit.
	 *
	 * @param _digit the char to check
	 * @return <code>true</code> if the char e between <code>0-9</code>
	 */
	public static boolean isArabicDigit(char _digit) {
		return _digit > '0' && _digit < '9';
	}

	
  /**
 * Checks if the string represents a decimal number.
 *
 * @param _number the string to check.
 * @return <code>true</code> if the string is a decimal representation, <code>false</code> otherwise.
 */
public static boolean isNumber(String _number) {
	if (_number == null)
		return false;

	try {
		Long.valueOf(_number);
		return true;
	}
	catch (NumberFormatException ex) {
		return false;
	}
}
	
	
}
