package util.PDF;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

import util.io.FileUtil;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;

// TODO: Auto-generated Javadoc
/**
 * The Class PDFUtil.
 */
public class PDFUtil {

    /**
     * This function recives a List of inputstream and creates a unique PDF and send it to an outputStream.
     * 
     * @param files
     *            the files
     * @param outputStream
     *            the output stream
     * @param paginate
     *            the paginate
     */

    public static void concatPDFs(ArrayList<String> files, OutputStream outputStream, boolean paginate)
    {

        Document document = new Document();
        try
        {
            java.util.List<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;

            // Create Readers for the pdfs.
            for (String filename: files)
            {
                InputStream pdf = new FileInputStream(filename);

                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
                pdf.close();
            }

            // Create a writer for the outputstream
            PdfWriter writer = PdfWriter.getInstance(document, outputStream);

            // document.open();
            BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
            PdfContentByte cb = null; // Holds the PDF
            // data

            PdfImportedPage page;
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            Iterator<PdfReader> iteratorPDFReader = readers.iterator();

            // Loop through the PDF files and add to the output.
            float y = 0;
            while (iteratorPDFReader.hasNext())
            {
                PdfReader pdfReader = iteratorPDFReader.next();
                document.setPageSize(pdfReader.getPageSize(1));
                if (!document.isOpen())
                {
                    document.open();
                    cb = writer.getDirectContent();
                }
                // Create a new page in the target for each source page.

                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages())
                {
                    document.setPageSize(pdfReader.getPageSize(1));
                    document.newPage();
                    pageOfCurrentReaderPDF++;

                    currentPageNumber++;
                    page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
                    cb.addTemplate(page, 0, y);

                    // Code for pagination.
                    if (paginate)
                    {
                        cb.beginText();
                        cb.setFontAndSize(bf, 9);
                        cb.showTextAligned(PdfContentByte.ALIGN_CENTER, "" + currentPageNumber + " of " + totalPages,
                                520, 5, 0);
                        cb.endText();
                    }
                    y = y + PageSize.LETTER.getBottom();
                    // y=y+30;
                    pdfReader.close();
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            if (document.isOpen())
                document.close();
            try
            {
                if (outputStream != null)
                    outputStream.close();
            }
            catch (IOException ioe)
            {
                ioe.printStackTrace();
            }
        }
    }

    /**
     * Create fields directly under de possition of the given field.
     * 
     * @param fldPos
     *            Position of the given field
     * @param stamper
     *            PDFStamper with the PDF where the field will be added
     * @param fldName
     *            Name of the new field
     * @param fldValue
     *            Value of the new field
     * @param i
     *            Multiplier of the position of the field
     * @param bgColor
     *            the bg color
     * @param fontSize
     *            the font size
     * @return TextField new field
     * @throws DocumentException
     *             the document exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static TextField createPDFFieldDyn(float fldPos[], PdfStamper stamper, String fldName, String fldValue,
            Integer i, Color bgColor, float fontSize) throws DocumentException, IOException
    {
        return createPDFFieldDyn(fldPos, stamper, fldName, fldValue, i, bgColor, fontSize, 0.0f);
    }

    /**
     * Create fields directly under de possition of the given field.
     * 
     * @param fldPos
     *            Position of the given field
     * @param stamper
     *            PDFStamper with the PDF where the field will be added
     * @param fldName
     *            Name of the new field
     * @param fldValue
     *            Value of the new field
     * @param i
     *            Multiplier of the position of the field
     * @param bgColor
     *            the bg color
     * @param fontSize
     *            the font size
     * @param spaceLines
     *            the space lines
     * @return TextField new field
     * @throws DocumentException
     *             the document exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static TextField createPDFFieldDyn(float fldPos[], PdfStamper stamper, String fldName, String fldValue,
            Integer i, Color bgColor, float fontSize, float spaceLines) throws DocumentException, IOException
    {
        TextField tf = null;
        PdfWriter writer = stamper.getWriter();
        BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.WINANSI, BaseFont.NOT_EMBEDDED);
        float llx = fldPos[1];
        float lly = fldPos[2] - ((fldPos[4] - fldPos[2]) * i) - spaceLines;
        float urx = fldPos[3];
        float ury = fldPos[4] - ((fldPos[4] - fldPos[2]) * i) - spaceLines;

        tf = new TextField(writer, new Rectangle(llx, lly, urx, ury), fldName);
        tf.setBackgroundColor(bgColor);
        tf.setFontSize(fontSize);
        tf.setFont(bf);
        tf.setText(fldValue);

        return tf;
    }

    /**
     * Create a multiline field directly under de possition of the given field.
     * 
     * @param fldPos
     *            Position of the given field
     * @param stamper
     *            PDFStamper with the PDF where the field will be added
     * @param fldName
     *            Name of the new field
     * @param fldValue
     *            An array with the lines of the field
     * @param i
     *            Multiplier of the position of the field
     * @param bgColor
     *            the bg color
     * @param fontSize
     *            the font size
     * @param spaceLines
     *            the space lines
     * @return TextField new field
     * @throws DocumentException
     *             the document exception
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public static TextField createPDFMultiLineFieldDyn(float fldPos[], PdfStamper stamper, String fldName,
            ArrayList<String> fldValue, Integer i, Color bgColor, float fontSize, float spaceLines)
            throws DocumentException, IOException
    {
        TextField tf = null;
        PdfWriter writer = stamper.getWriter();

        int numberLines = 0;
        int numeroEnters = 0;
        String value = "";
        for (String string: fldValue)
        {
            if (string.length() != 0 && string.length() <= 38)
            {
                numberLines += 1;
            }
            else if (string.length() != 0 && string.length() > 38)
            {
                numberLines += 1;
                numeroEnters += (Math.ceil(new Double(string.length()).doubleValue() / new Double(38).doubleValue())) / 2;
            }
            value += string + "\n";
        }
        if (numeroEnters > 0)
        {
            int val = 0;
            val += Math.ceil(numeroEnters / 1.5);
            numberLines = numberLines + val;
        }
        BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.WINANSI, BaseFont.NOT_EMBEDDED);
        float llx = fldPos[1];
        float lly = fldPos[2] - ((fldPos[4] - fldPos[2]) * (i + numberLines - 1)) - spaceLines;
        float urx = fldPos[3];
        float ury = fldPos[4] - ((fldPos[4] - fldPos[2]) * i) - spaceLines;

        tf = new TextField(writer, new Rectangle(llx, lly, urx, ury), fldName);
        tf.setOptions(BaseField.MULTILINE);
        tf.setBackgroundColor(bgColor);
        tf.setFontSize(fontSize);
        tf.setFont(bf);
        tf.setText(value);

        return tf;
    }

    /**
     * Gets the aula row border.
     * 
     * @param ultima
     *            the ultima
     * @return the aula row border
     */
    public static Rectangle getAulaRowBorder(boolean ultima)
    {
        return getBorder(0.5f, (ultima ? 1f : 0.5f), 0f, 0f, Color.BLACK);
    }

    /**
     * Builds a <code>Rectangle</code> representing the border of the.
     * 
     * @param left
     *            left border size
     * @param right
     *            right border size
     * @param top
     *            top border size
     * @param bottom
     *            bottom border size
     * @param clr
     *            Color of the border.
     * @return <code>Rectangle</code> that represents the border.
     */
    public static Rectangle getBorder(float left, float right, float top, float bottom, Color clr)
    {
        Rectangle border = new Rectangle(0f, 0f);
        border.setBorderWidthLeft(left);
        border.setBorderWidthRight(right);
        border.setBorderWidthTop(top);
        border.setBorderWidthBottom(bottom);
        border.setBorderColor(clr);
        return border;
    }

    /**
     * Gets the header row border.
     * 
     * @param ultima
     *            the ultima
     * @return the header row border
     */
    public static Rectangle getHeaderRowBorder(boolean ultima)
    {
        return getBorder(1f, (ultima ? 2f : 1f), 2f, 2f, Color.BLACK);
    }

    /**
     * Gets the normal row border.
     * 
     * @param ultima
     *            the ultima
     * @return the normal row border
     */
    public static Rectangle getNormalRowBorder(boolean ultima)
    {
        return getBorder(0.5f, (ultima ? 1f : 0.5f), 0f, 1f, Color.BLACK);
    }

    /**
     * The main method.
     * 
     * @param args
     *            the arguments
     */
    public static void main(String[] args)
    {
        try
        {
            String fileNameFull = FileUtil.getTempDir() + "NOME_DE_TESTE.pdf";
            File file = new File(fileNameFull);
            FileOutputStream fout = null;
            if (file.createNewFile())
            {
                fout = new FileOutputStream(file);
            }
            PDFUtil.makeTesteDocument(fout);
            // PDFUtil.makeDocument(fout);
        }
        catch (FileNotFoundException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        catch (IOException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * Makes a <code>PdfPCell</code>.
     * 
     * @param texto
     *            text to be included inside the cell
     * @param textSize
     *            the text size
     * @param vAlignment
     *            vertical alignment
     * @param hAlignment
     *            horizontal alignment
     * @param borders
     *            a <code>Rectangle</code> representing the borders
     * @param bgColor
     *            background color
     * @param minimumHeight
     *            minimum height of the cell
     * @param nowrap
     *            indicates if the wrap is active or not
     * @param colSpan
     *            the col span
     * @return Makes <code>PdfPCell</code>
     */
    public static PdfPCell makeCell(String texto, int textSize, int vAlignment, int hAlignment, Rectangle borders,
            Color bgColor, float minimumHeight, boolean nowrap, int colSpan)
    {

        Paragraph p = makeParagraph(texto, textSize);

        PdfPCell cell = new PdfPCell(p);
        cell.setVerticalAlignment(vAlignment);
        cell.setHorizontalAlignment(hAlignment);
        cell.cloneNonPositionParameters(borders);
        cell.setUseBorderPadding(false);
        cell.setBackgroundColor(bgColor);
        cell.setNoWrap(nowrap);
        cell.setMinimumHeight(minimumHeight);
        if (colSpan > 1)
        {
            cell.setColspan(colSpan);
        }
        return cell;
    }

    /**
     * Make document.
     * 
     * @param output
     *            the output
     */
    public static void makeDocument(OutputStream output)
    {
        Document document = new Document(PageSize.LETTER);

        try
        {
            PdfWriter.getInstance(document, output);
            document.open();
            document.setPageSize(PageSize.LETTER);
            int numCols = 8;
            PdfPTable table = makeTable(numCols, 100f);

            ArrayList<String> rows = new ArrayList<String>();
            rows.add("Primeira");
            rows.add("Segunda");
            rows.add("Terceira");
            rows.add("Quarta");
            rows.add("Quinta");
            rows.add("Sexta");
            rows.add("S�tima");
            rows.add("Oitava");
            rows.add("D�cima");
            rows.add("Segunda");
            rows.add("Terceira");
            rows.add("Quarta");
            rows.add("Quinta");
            rows.add("Sexta");
            rows.add("S�tima");
            rows.add("Oitava");
            rows.add("D�cima");
            rows.add("Segunda");
            rows.add("Terceira");
            rows.add("Quarta");
            rows.add("Quinta");
            rows.add("Sexta");
            rows.add("S�tima");
            rows.add("Oitava");
            rows.add("D�cima");
            rows.add("Segunda");
            rows.add("Oitava");
            rows.add("D�cima");
            rows.add("Segunda");
            rows.add("Terceira");
            rows.add("Quarta");
            rows.add("Quinta");
            rows.add("Sexta");
            rows.add("S�tima");
            rows.add("Oitava");
            rows.add("D�cima");
            rows.add("Segunda");

            // ROWS
            for (String r: rows)
                makeRow(table, r, numCols);

            document.add(table);

        }
        catch (DocumentException de)
        {
            System.err.println(de.getMessage());
        }
        if (document != null && document.isOpen())
        {
            document.close();
        }
    }

    /**
     * Creates a new paragraph.
     * 
     * @param texto
     *            The text to be included in the paragraph
     * @param fontSize
     *            The size of the font in the paragraph.
     * @return A new <code>Paragraph</code> with the text in <code>texto</code>
     */
    private static Paragraph makeParagraph(String texto, int fontSize)
    {
        Paragraph p = new Paragraph();
        Font font = FontFactory.getFont(FontFactory.HELVETICA, fontSize, Font.NORMAL);
        p.setFont(font);
        p.add(texto);
        return p;
    }

    /**
     * Make row.
     * 
     * @param table
     *            the table
     * @param row
     *            the row
     * @param numCols
     *            the num cols
     */
    public static void makeRow(PdfPTable table, String row, int numCols)
    {

        for (int i = 0; i < numCols; i++)
        {
            // cores
            Color clr = null;
            if (i == 0)
            {
                clr = Color.GRAY;
            }
            else
            {
                clr = Color.WHITE;
            }

            String texto = "";
            // border
            Rectangle border = null;
            if (row.equals("Primeira"))
            {
                border = getHeaderRowBorder(i == numCols - 1);
                clr = Color.GRAY;
            }
            else if (row.equals("Terceira") && i == 3)
            {
                texto = row + " -> " + i + row + " -> " + i;
                border = getAulaRowBorder(i == numCols - 1);
                clr = Color.GREEN;
            }
            else if (row.equals("Quarta") && i == 3)
            {
                border = getAulaRowBorder(i == numCols - 1);
                clr = Color.GREEN;
            }
            else if (row.equals("Quinta") && i == 3)
            {
                border = getNormalRowBorder(i == numCols - 1);
                clr = Color.GREEN;
            }
            else if (row.equals("Quinta") && i == 4)
            {
                texto = row + " -> " + i + "\n" + row + " -> " + i + "\n";
                border = getAulaRowBorder(i == numCols - 1);
                clr = Color.YELLOW;
            }
            else if (row.equals("Sexta") && i == 4)
            {
                border = getNormalRowBorder(i == numCols - 1);
                clr = Color.YELLOW;
            }
            else
            {
                border = getNormalRowBorder(i == numCols - 1);
            }

            System.out.println(row + " -> " + i);
            PdfPCell cell = makeCell(texto, 6, Element.ALIGN_TOP, Element.ALIGN_LEFT, border, clr, 16f, false, 0);
            table.addCell(cell);
        }
    }

    /**
     * Starts a new PDF table with the number of columns specified in <code>numcols</numcols> and ocupping
     * a with percentage specified in <code>widthPercentage</code>.
     * 
     * @param numCols
     *            number of columns.
     * @param widthPercentage
     *            percentage of the page width ocupied by the table.
     * @return An <code>PdfPTable</code> correctly initiated.
     */
    public static PdfPTable makeTable(int numCols, float widthPercentage)
    {
        PdfPTable table = new PdfPTable(numCols);
        table.setWidthPercentage(widthPercentage);
        table.setHeaderRows(1);
        return table;
    }

    /**
     * Starts a new PDF table with the number of columns specified in <code>numcols</numcols> and ocupping
     * a with percentage specified in <code>widthPercentage</code>.
     * 
     * @param numCols
     *            number of columns.
     * @param widthPercentage
     *            percentage of the page width ocupied by the table.
     * @param collsWidths
     *            Width percentage of the columns.
     * @return An <code>PdfPTable</code> correctly initiated.
     * @throws DocumentException
     *             Exception happens when the number of the columns is diferent of the collsWidths
     */
    public static PdfPTable makeTable(int numCols, float widthPercentage, float[] collsWidths) throws DocumentException
    {
        PdfPTable table = PDFUtil.makeTable(numCols, widthPercentage);
        table.setWidths(collsWidths);
        return table;
    }

    /**
     * Make teste document.
     * 
     * @param output
     *            the output
     */
    public static void makeTesteDocument(OutputStream output)
    {
        Document document = new Document();

        try
        {
            PdfWriter.getInstance(document, output);
            document.open();
            // document.setPageSize(PageSize.A4);
            int numCols = 4;

            float[] collumswith = new float[numCols];
            for (int i = 1; i < collumswith.length; i++)
            {
                collumswith[i] = 20f;
            }

            PdfPTable table = new PdfPTable(11);
            // table.setWidths(collumswith);
            // table.setKeepTogether(true);

            /*
             * PdfPCell cell = new PdfPCell(new Paragraph("header with colspan 3")); cell.setColspan(3);
             * table.addCell(cell);
             */
            // table.addCell("Header1");
            // table.addCell("Header2");
            PdfPCell header1 = new PdfPCell(new Paragraph("header1"));
            header1.setColspan(2);
            table.addCell(header1);
            PdfPCell header2 = new PdfPCell(new Paragraph("header2"));
            header2.setColspan(2);
            table.addCell(header2);
            PdfPCell header3 = new PdfPCell(new Paragraph("header3"));
            header3.setColspan(3);
            table.addCell(header3);
            PdfPCell header4 = new PdfPCell(new Paragraph("header4"));
            header4.setColspan(1);
            table.addCell(header4);
            PdfPCell header5 = new PdfPCell(new Paragraph("header5"));
            header5.setColspan(1);
            table.addCell(header5);
            PdfPCell header6 = new PdfPCell(new Paragraph("header6"));
            header6.setColspan(1);
            table.addCell(header6);
            PdfPCell header7 = new PdfPCell(new Paragraph("header7"));
            header7.setColspan(1);
            table.addCell(header7);

            table.addCell("O tamanho da letra 1.1");
            table.addCell("O tamanho da letra 1.2");
            table.addCell("O tamanho da letra 1.3");
            table.addCell("1.4");
            table.addCell("1.5");
            table.addCell("1.6");
            table.addCell("1.7");
            table.addCell("1.8");
            table.addCell("1.9");
            table.addCell("1.10");
            table.addCell("1.11");
            PdfPCell cell21 = new PdfPCell(new Paragraph("2.1"));
            cell21.setColspan(2);
            table.addCell(cell21);
            PdfPCell cell22 = new PdfPCell(new Paragraph("2.2"));
            cell22.setColspan(2);
            table.addCell(cell22);
            table.addCell("2.3");
            table.addCell("2.4");
            table.addCell("2.5");
            table.addCell("2.6");
            table.addCell("2.7");
            table.addCell("2.8");
            table.addCell("2.9");
            table.addCell("3.1");
            table.addCell("3.2");
            table.addCell("3.3");
            table.addCell("3.4");
            PdfPCell cell35 = new PdfPCell(new Paragraph("3.5"));
            cell35.setColspan(3);
            table.addCell(cell35);
            table.addCell("3.5");
            table.addCell("3.6");
            table.addCell("3.7");
            table.addCell("3.8");
            table.addCell("4.1");
            table.addCell("4.2");
            table.addCell("4.3");
            table.addCell("4.4");
            table.addCell("4.5");
            table.addCell("4.6");
            table.addCell("4.7");
            table.addCell("4.8");
            table.addCell("4.9");
            table.addCell("4.10");
            table.addCell("4.11");
            document.add(table);

        }
        catch (DocumentException de)
        {
            System.err.println(de.getMessage());
        }
        if (document != null && document.isOpen())
        {
            document.close();
        }
    }

    /**
     * Rotates the page.
     * 
     * @param reader
     *            PDF reader
     * @param page
     *            The page number
     * @param rotation
     *            the rotation angle
     */
    public static void rotatePage(PdfReader reader, Integer page, int rotation)
    {
        PdfDictionary pageDict;
        int rot = reader.getPageRotation(page);
        pageDict = reader.getPageN(page);
        pageDict.put(PdfName.ROTATE, new PdfNumber(rot + rotation));
    }
}