package util;

import java.util.HashMap;
import java.util.Map;

// TODO: Auto-generated Javadoc
/**
 * Manipulates yes or no for diferente languages.
 * 
 * @author Daniel Campelo (Changed/Optimized structure)
 */
public class SimNaoData {

    /** 'No' default code. */
    public static final String CODE_NO = "N";
    /** 'Yes' default code. */
    public static final String CODE_YES = "S";

    /** The Constant DEFAULT_LANGUAGE. */
    private static final String DEFAULT_LANGUAGE = "PT";
    
    /** The translations. */
    private static Map<String, SimNaoData> translations;

    static
    {
        translations = new HashMap<String, SimNaoData>();
        // TODO It's HARDCODED!!!
        translations.put("PT", new SimNaoData("Sim", "N&atilde;o"));
        translations.put("EN", new SimNaoData("Yes", "No"));
        translations.put("ES", new SimNaoData("Si", "No"));
    }

    /**
     * Gets the text of the 'yes' or 'no' on the specified language. The the code specified is checked so that the text
     * is retreaved correctly based on the language.
     * 
     * @param codYesNo
     *            the code to get the text of
     * @param keyLanguage
     *            the language in which the text is to be retreaved
     * @return the text of the code in the specified language
     */
    public static String decodeDescription(String codYesNo, String keyLanguage)
    {
        if (codYesNo.equals(CODE_YES))
        {
            return getYes(keyLanguage);

        }
        else if (codYesNo.equals(CODE_NO))
        {
            return getNo(keyLanguage);

        }
        return "";
    }

    /**
     * The 'yes'/'no' data of the specified language.
     * 
     * @param keyLanguage
     *            the language name
     * @return the data
     */
    public static SimNaoData getData(String keyLanguage)
    {
        SimNaoData res = null;
        if (keyLanguage != null)
        {
            res = translations.get(keyLanguage);
        }

        if (res == null)
        {
            res = translations.get(DEFAULT_LANGUAGE);
        }

        return res;
    }

    /**
     * The 'no' of the specified language.
     * 
     * @param keyLanguage
     *            the language name
     * @return the translation
     */
    public static String getNo(String keyLanguage)
    {

        return getData(keyLanguage).getDescNo();
    }

    /**
     * The 'yes' of the specified language.
     * 
     * @param keyLanguage
     *            the language name
     * @return the translation
     */
    public static String getYes(String keyLanguage)
    {
        return getData(keyLanguage).getDescYes();
    }

    /** The desc no. */
    private String descNo = null;

    /** The desc yes. */
    private String descYes = null;

    /**
     * Instantiates a new sim nao data.
     *
     * @param descYes the desc yes
     * @param descNo the desc no
     */
    public SimNaoData(String descYes, String descNo)
    {
        this.setDescYes(descYes);
        this.setDescNo(descNo);
    }

    /**
     * Gets the 'no' description of this instance.
     * 
     * @return the 'no' description
     */
    public String getDescNo()
    {
        return descNo;
    }

    /**
     * Gets the 'yes' description of this instance.
     * 
     * @return the 'yes' description
     */
    public String getDescYes()
    {
        return descYes;
    }

    /**
     * Sets the 'no' description of this instance.
     *
     * @param descNo the new desc no
     */
    public void setDescNo(String descNo)
    {
        this.descNo = descNo;
    }

    /**
     * Sets the 'yes' description of this instance.
     * 
     * @param descYes
     *            the 'yes' description to set
     */
    public void setDescYes(String descYes)
    {
        this.descYes = descYes;
    }
}
