/*
 * Created on 17/Nov/2004 TODO To change the template for this generated file go to Window - Preferences - Java - Code
 * Style - Code Templates
 */
package util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the manipulation/validation of strings.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 *         Created on 17/Nov/2004
 */
public class StringUtil {

    /**
     * Checks if an email as a valid format.
     * 
     * @param email
     *            Email to be checked
     * @return true if the email as a valid format and false if not.
     */
    public static boolean checkEmail(String email)
    {
        final String regExp = "^([\\w-]+(?:\\.[\\w-]+)*)@((?:[\\w-]+\\.)*\\w[\\w-]{0,66})\\.([a-z]{2,6}(?:\\.[a-z]{2})?)$";

        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(email);

        return matcher.matches();

    }

    /**
     * Generates a random String.
     * 
     * @param size
     *            the lenght of the string to generate
     * @return the random generated string
     */
    static final public String generateRandomString(int size)
    {
        String res = new String();
        java.util.Random rand = new java.util.Random();
        int i = 0;
        while (i < size)
        {
            char ch = (char) rand.nextInt(255);
            if (NumberUtil.isArabicDigit(ch) || CharUtil.isLatinLetter(ch))
            {
                res += ch + "";
                i++;
            }
        }
        return res;
    }

    /**
     * Obtains the first word in a String.
     * 
     * @param value
     *            the string to analyse
     * @return The first word in the String if the string doesn't have a last word return an empty String
     */
    public static String getFirstWord(String value)
    {
        if (value != null && value.length() > 0)
            return subString("\\A\\S+", value.trim());
        else
            return "";
    }

    /**
     * Obtains the last word in a String.
     * 
     * @param value
     *            the string to truncate
     * @return The last word in the String if the string doesn't have a last word return an empty String
     */
    public static String getLastWord(String value)
    {
        if (value != null && value.length() > 0)
            return subString("\\S+\\z", value.trim());
        else
            return "";
    }

    /**
     * Removes the accents from a string.
     * 
     * @param _strToConvert
     *            string to strip off of accents
     * @return the string without accents
     */
    public final static String removeAcentos(String _strToConvert)
    {
        String res = _strToConvert;
        final int[] ACENTOS = {193, 194, 195, 201, 202, 205, 211, 213, 212, 218, 199, 225, 226, 227, 233, 234, 237,
                            243, 245, 244, 250, 252, 231, 36};
        final String CHARS = "AAAEEIOOOUCaaaeeiooouuc_";

        for (int i = 0; i < ACENTOS.length; i++)
        {
            res = res.replaceAll(((char) ACENTOS[i]) + "", CHARS.charAt(i) + "");
        }
        return res;
    }

    /**
     * Removes a list if chars from a String.
     * 
     * @param toClean
     *            the string to be cleaned
     * @param regExp
     *            the matching criteria used to remove itens from a string
     * @return the cleaned String
     */
    public static String removeItens(String toClean, String regExp)
    {
        return replaceItens(toClean, regExp, "", 0);
    }

    /**
     * Removes a list if chars from a String.
     * 
     * @param toClean
     *            : The String to be cleaned
     * @param regExp
     *            the reg exp
     * @param mode
     *            the mode
     * @return the cleaned String
     */
    public static String removeItens(String toClean, String regExp, int mode)
    {
        return replaceItens(toClean, regExp, "", mode);
    }

    /**
     * Replaces a value for another in a string.
     * 
     * @param _str
     *            the String to be replaced
     * @param _pattern
     *            he pattern to find the text to replace
     * @param _newValue
     *            the new value to be aplied
     * @return the replaced string
     */
    public final static String replace(String _str, String _pattern, String _newValue)
    {
        Pattern pattern = Pattern.compile(_pattern);
        Matcher matcher = pattern.matcher(_str);
        return matcher.replaceAll(_newValue);
    }

    /**
     * Replaces a set of values for another in a string.
     * 
     * @param _str
     *            the String to be replaced
     * @param _patterns
     *            the list of patterns to find the text to replace
     * @param _newValues
     *            the list of new value to be aplied
     * @return the replaced string
     */
    public final static String replace(String _str, String[] _patterns, String[] _newValues)
    {
        String resStr = _str;
        for (int i = 0; i < _patterns.length; i++)
        {
            Pattern pattern = Pattern.compile(_patterns[i]);
            Matcher matcher = pattern.matcher(resStr);
            resStr = matcher.replaceAll(_newValues[i]);
        }
        return resStr;
    }

    /**
     * Removes a list if chars from a String.
     * 
     * @param toClean
     *            : The String to be cleaned
     * @param regExp
     *            the reg exp
     * @param newValue
     *            the new value
     * @return the cleaned String
     */
    public static String replaceItens(String toClean, String regExp, String newValue)
    {
        return replaceItens(toClean, regExp, newValue, 0);
    }

    /**
     * Removes a list if chars from a String.
     * 
     * @param toClean
     *            : The String to be cleaned
     * @param regExp
     *            the reg exp
     * @param newValue
     *            the new value
     * @param mode
     *            the mode
     * @return the cleaned String
     */
    public static String replaceItens(String toClean, String regExp, String newValue, int mode)
    {
        Pattern pattern = Pattern.compile(regExp, mode);
        String init = "";
        String res = toClean;
        try
        {
            while (!res.equals(init))
            {
                init = res;
                Matcher matcher = pattern.matcher(init);
                res = matcher.replaceAll(newValue);
            }
        }
        catch (IllegalStateException ise)
        {
        }

        return res;
    }

    /**
     * Strips a string using a regular expression.
     * 
     * @param regExp
     *            the regular expression
     * @param value
     *            the string to be sub-stringed
     * @return the matching value of the string
     */
    public static String subString(String regExp, String value)
    {
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(value);

        if (matcher.find())
        {
            return value.substring(matcher.start(), matcher.end());
        }
        return "";
    }

    /**
     * Gets a portion of a string based on the matching criteria defined by a regular expression and the matcher group.
     * 
     * @param regExp
     *            the regular expression
     * @param value
     *            the string to get the value from
     * @param matchGroup
     *            the matching group defined by the regular expression
     * @return the matching value of the string
     */
    public static String subString(String regExp, String value, int matchGroup)
    {
        return subString(regExp, value, matchGroup, 0);
    }

    /**
     * Sub string.
     * 
     * @param regExp
     *            the reg exp
     * @param value
     *            the value
     * @param matchGroup
     *            the match group
     * @param mode
     *            the mode
     * @return the string
     */
    public static String subString(String regExp, String value, int matchGroup, int mode)
    {
        Pattern pattern = Pattern.compile(regExp, mode);
        Matcher matcher = pattern.matcher(value);

        if (matcher.find())
        {
            return matcher.group(matchGroup);
        }
        return "";
    }

    /**
     * Truncate a string to a maximum length.
     * 
     * @param value
     *            the string to truncate
     * @param maxSize
     *            the maximum length alowed
     * @return the first n chars of the string, where n equals the maximum length defined. If the string is lower or
     *         equal to the maximum length then it's returned
     */
    public static String truncate(String value, int maxSize)
    {
        return (value.length() > maxSize ? value.substring(0, maxSize) : value);
    }

}
