/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.collection;

// TODO: Auto-generated Javadoc
/**
 * Utility class used to perform validations over Arrays.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a>
 * Created : Oct 24, 2005
 */
public class ArrayUtil {
	
	/**
	 * Searchs for an object in an <code>array</code>.
	 *
	 * @param <T> the generic type
	 * @param objs  the array of objects
	 * @param objToCheck the object to find
	 * @return <code>true</code> if the object exists in the array, otherwise <code>false</code>
	 */
	public static final <T extends Object> boolean contains(T[] objs, T objToCheck){
		boolean found = false;
		for (int i = 0; i < objs.length && !found; i++) {
			found = objs[i].equals(objToCheck);
		}
		return found;
	}
	
	/**
	 * Merge array.
	 *
	 * @param array the array
	 * @param newArray the new array
	 * @return the string[]
	 */
	public static final String[] mergeArray(String[] array, String[] newArray){
		String[] result = new String[array.length + newArray.length];
		
		for( int i=0; i< array.length;i++){
			result[i] = array[i];
		}
		
		for( int i=0; i< newArray.length;i++){
			result[i+array.length] = newArray[i];
		}
		
		return result;
	}
	
}
