/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.collection;

import java.util.Enumeration;

import util.Matcher;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to manipulate enumerations, iterators and relatated objects.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * Created : 12/Mai/2005
 */
public class EnumerationUtil {
	
	/**
	 * Searchs the first <code>Object</code> that matchs the critreria defined by the matcher.
	 *
	 * @param <T> the generic type
	 * @param enumeration the enumeration
	 * @param matcher the search criteria
	 * @return The object found or <code>null</code> if no <code>Object</code> matchs the criteria.
	 */
	public static <T extends Object> T findFirst( Enumeration<T> enumeration, Matcher<T> matcher){
		while (enumeration.hasMoreElements()){
			T obj = enumeration.nextElement();
			if(matcher.matchs( obj)){
				return obj;
			}
		}
		return null;
	}
}
