/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

import util.Filter;

// TODO: Auto-generated Javadoc
/**
 * An iterator implementation that wrappes an iterator so that it may filter it's itens.
 *
 * @param <T> the generic type
 */
public class FilterIterator<T> implements Iterator<T> {
	
	/** The filter. */
	private Filter<T> filter = null;
	
	/** The iter aux. */
	private Iterator<T> iterAux = null;
	
	/** The last checked item. */
	private T lastCheckedItem = null;

	/**
	 * Wrappes an iterator applying a filter when retreaving the itens.
	 * @param iterator the iterator to filter
	 * @param filter the filter to apply
	 */
	public FilterIterator( Iterator<T> iterator, Filter<T> filter){
		this.iterAux = iterator;
		this.filter = filter;
	}

	/**
	 * Checks if theres any more itens that would be returned if the @link MenuParametersIterator#next() method was to be called.
	 * @return <code>true</code> if theres more itens to be returned by the iterator
	 */
	public boolean hasNext(){
		if(lastCheckedItem != null){
			return true;
		}

		if(!iterAux.hasNext()){
			return false;
		} else {
			try{
				this.lastCheckedItem = this.next();
				return true;
			}catch(NoSuchElementException e){
				return false;
			}
		}
	}

	/**
	 * Gets the next item from the iterator that is accepted by the specified filter.
	 *
	 * @return the next item that is accepted by the filter
	 */
	public T next(){
		if(this.lastCheckedItem != null){
			T temp = this.lastCheckedItem;
			// Cleans up
			this.lastCheckedItem = null;
			return temp;

		} else {
			T temp;
			do{ temp = iterAux.next();
			}while( !this.filter.accept(temp));
			return temp;
		}
	}
	
	/**
	 * Empty implementation, does absolutly nothing.
	 */
	public void remove(){
		// Does nothing
	}
}
