/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import util.Filter;
import util.ObjectCompare;

// TODO: Auto-generated Javadoc
/**
 * The Class MapUtil.
 *
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a>
 * Created : 19/Jul/2005
 */
public class MapUtil {
	
	/**
	 * Checks if two <code>Maps</code> are equal.
	 * The criteria to define that two <code>Maps</code> is :
	 * - both Maps are null or empty;
	 * - have the same number of itens;
	 * - must have all itens names equal;
	 * - the values, refered by the name, must be equal. Being it's equal criteria defined by the objComparer parameter;
	 *
	 * @param <V1> the generic type
	 * @param <V2> the generic type
	 * @param map1   the map to compare
	 * @param map2   the map to compare
	 * @param objComparer the comparator that defined the equal criteria of the values
	 * @return true if both Maps are equal false otherwise
	 */
	public static <V1,V2 extends Object> boolean compareMaps(Map<String,V1> map1, Map<String,V2> map2, ObjectCompare<V1, V2> objComparer){
		// Checks if both maps are the same or if are both empty
		if(map1 == map2 || (map1.isEmpty() && map2.isEmpty())){
			return true;
		}

		Set<String> keys = map1.keySet();
		// Checks if the number of elements are equal
		if(keys.size() != map2.size()){
			return false;
		}

		boolean found = true;
		Iterator<String> iter = keys.iterator();
		while(iter.hasNext() && found){
			String key = iter.next();

			// Checks if map2 has the key and if both values are 'equal' using the ObjectCompare critiria
			found = map2.containsKey(key) && objComparer.compare( map1.get( key), map2.get( key));
		}

		return found;
	}

	/**
	 * Copies a map content ignoring the rows where the keys don't fullfill the codition defined in the <code>keyFilter</code> or the values that don't corresponde to the <code>valueFilter</code>.
	 * Both the filters may be <code>null</code> or just one.
	 * 
	 * @param <K> the key object
	 * @param <V> the value object
	 * @param fromMap the map to copy the contents from
	 * @param toMap the map to copy the contents to
	 * @param keyFilter the key filter (may be <code>null</code>)
	 * @param valueFilter the value filter (may be <code>null</code>)
	 * @return the toMap
	 */
	public static <K, V extends Object> Map<K, V> copyMapFiltered( Map<K, V> fromMap, Map<K, V> toMap, Filter<K> keyFilter, Filter<V> valueFilter){
		
		// Checks if the key filter is not specified
		if(keyFilter == null){
			// Creates a new filter that will accept all keys
			keyFilter = new Filter<K>(){
								public boolean accept(K _objToCheck){
									return true;
								}
							};
		}
		
		// Gets the iterator that will use the filter specified
		FilterIterator<K> keyIter = new FilterIterator<K>( fromMap.keySet().iterator(), keyFilter);

		while(keyIter.hasNext()){
			K key = keyIter.next();
			V value = fromMap.get( key);
			
			// Checks if the value filter is specified and if the value is valid
			if(valueFilter == null || valueFilter.accept(value)){
				toMap.put(key, value);
			}
		}

		// Returns the map with the copied rows
		return toMap;
	}
}
