/**
 * First created between November and December 2003 1994-2003 Digitalis Informatica. All rights reserved. Distribuicao e
 * Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21
 * 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package util.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

// TODO: Auto-generated Javadoc
/**
 * The Class ReadOnlyMap.
 * 
 * @param <K>
 *            the key type
 * @param <V>
 *            the value type
 */
public class ReadOnlyMap<K, V> implements Map<K, V> {

    /** The wrapped map. */
    private final Map<K, V> wrappedMap;

    /**
     * Instantiates a new read only map.
     * 
     * @param mapToWrap
     *            the map to wrap
     */
    public ReadOnlyMap(Map<K, V> mapToWrap)
    {
        this.wrappedMap = mapToWrap;
    }

    /**
     * @see java.util.Map#clear()
     */
    public void clear()
    {
        throw new UnsupportedOperationException("This implementation is readonly");
    }

    /**
     * @see java.util.Map#containsKey(java.lang.Object)
     */
    public boolean containsKey(Object key)
    {
        return this.wrappedMap.containsKey(key);
    }

    /**
     * @see java.util.Map#containsValue(java.lang.Object)
     */
    public boolean containsValue(Object value)
    {
        // TODO Auto-generated method stub
        return this.wrappedMap.containsValue(value);
    }

    /**
     * @see java.util.Map#entrySet()
     */
    public Set<Map.Entry<K, V>> entrySet()
    {
        return this.wrappedMap.entrySet();
    }

    /**
     * @see java.util.Map#get(java.lang.Object)
     */
    public V get(Object key)
    {
        // TODO Auto-generated method stub
        return this.wrappedMap.get(key);
    }

    /**
     * @see java.util.Map#isEmpty()
     */
    public boolean isEmpty()
    {
        return this.wrappedMap.isEmpty();
    }

    /**
     * @see java.util.Map#keySet()
     */
    public Set<K> keySet()
    {
        return this.wrappedMap.keySet();
    }

    /**
     * @see java.util.Map#put(java.lang.Object, java.lang.Object)
     */
    public V put(K key, V value)
    {
        throw new UnsupportedOperationException("This implementation is readonly");
    }

    /**
     * @see java.util.Map#putAll(java.util.Map)
     */
    @SuppressWarnings("rawtypes")
    public void putAll(Map t)
    {
        throw new UnsupportedOperationException("This implementation is readonly");
    }

    /**
     * @see java.util.Map#remove(java.lang.Object)
     */
    public V remove(Object key)
    {
        throw new UnsupportedOperationException("This implementation is readonly");
    }

    /**
     * @see java.util.Map#size()
     */
    public int size()
    {
        return this.wrappedMap.size();
    }

    /**
     * @see java.util.Map#values()
     */
    public Collection<V> values()
    {
        return this.wrappedMap.values();
    }

}
