/**
 * First created between November and December 2003 1994-2003 Digitalis Informatica. All rights reserved. Distribuicao e
 * Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21
 * 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package util.cripto;

import java.sql.Timestamp;
import java.text.ParseException;

import util.StringUtil;
import util.dateutils.DateConverter;

// TODO: Auto-generated Javadoc
/**
 * Checks the integrity of the registration key of the applications.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 *         Created : 20/Dez/2004
 */
public final class ApplicationRegistration {

    /**
     * The date format used.
     */
    private static final String DATE_FORMAT = "ddMMyyyy";
    /**
     * Full version date.
     */
    private static final String FULL_VERSION_DATE = "00000000";
    /**
     * Random key used for the generation of the key.
     */
    private static final String GENERATION_RANDOM_KEY = "125DFsrSss7254Si";
    /**
     * Registration key spliter.
     */
    private static final String SPLITER_REGISTRATION_KEY = "-&-";

    /**
     * Checks if the registration key is valid. Must check if date of the key has already expired
     * 
     * @param _client
     *            the client to whom the application is registered
     * @param _app
     *            application to that the key belongs to
     * @param _regKeyToCheck
     *            key to check
     * @return <code>true</code> if the key is correct and the expirancy date wasn't reached, <code>false</code>
     *         otherwise
     */
    public static boolean checkKey(String _client, String _app, String _regKeyToCheck)
    {
        String client = StringUtil.removeAcentos(_client);
        String app = StringUtil.removeAcentos(_app);

        // Valida se a chave ? null ou se n?o tem a cadeia de caracteres que separa os dois processos
        if (!simpleKeyCheck(_regKeyToCheck))
        {
            return false;
        }

        boolean keyOk = false;

        // Separa os dois processamentos da chave de registo
        String[] str = _regKeyToCheck.split(ApplicationRegistration.SPLITER_REGISTRATION_KEY);

        try
        {
            // Processamento 1
            {
                // Inverte o segundo passo do primeiro processamento
                String aux = CryptoUtil.deencript(str[0], ApplicationRegistration.GENERATION_RANDOM_KEY);

                // Obtem o cliente que registou a aplica??o (primeiro passo do primeiro processamento)
                String clientEnc = CryptoUtil.deencript(aux, app);

                // Verifica se o cliente ? o correcto
                keyOk = clientEnc.equals(client);
            }

            // Processamento 2 - Se o 1 processamento estiver errado n?o ? necess?rio efectuar a valida??o do segundo
            // processamento
            if (keyOk)
            {
                // Inverte o terceiro passo do segundo processamento
                String aux = CryptoUtil.deencript(str[1], ApplicationRegistration.GENERATION_RANDOM_KEY);

                // Inverte o segundo passo do segundo processamento
                aux = CryptoUtil.deencript(aux, app);

                // Obtem data de expira??o da chave de registo (primeiro passo do segundo processamento)
                String dateEnc = CryptoUtil.deencript(aux, client);

                // Verifica se ? uma trial version
                if (!dateEnc.equals(ApplicationRegistration.FULL_VERSION_DATE))
                {
                    Timestamp dateTrial = null;
                    Timestamp dateCur = null;
                    try
                    {
                        dateTrial = DateConverter.stringToTimestamp(dateEnc, ApplicationRegistration.DATE_FORMAT);
                        dateCur = DateConverter.longToTimestamp(System.currentTimeMillis(),
                                ApplicationRegistration.DATE_FORMAT);

                        // Se a trial terminou n?o poder? utilizar mais a chave
                        keyOk = (!dateCur.after(dateTrial));
                    }
                    catch (ParseException pe)
                    {
                        pe.printStackTrace();
                        // Excep??o a fazer o parse da data, chave n?o est? correcta
                        keyOk = false;
                    }
                }
            }
        }
        catch (CryptException ce)
        {
            ce.printStackTrace();
            keyOk = false;
        }
        return keyOk;
    }

    /**
     * Creates a key based on the aplication, client and the date.
     * 
     * @param _client
     *            client to use in the encriptation
     * @param _app
     *            aplication to use in the encriptation
     * @param _date
     *            date to use in the encriptation
     * @return The generated key
     */
    private static String encript(String _client, String _app, String _date)
    {
        String client = StringUtil.removeAcentos(_client);
        String app = StringUtil.removeAcentos(_app);

        String res = null;
        String processamento1 = null;
        String processamento2 = null;
        try
        {
            // Processamento 1
            {
                // encriptar a institui??o tendo como base a aplica??o
                String aux = CryptoUtil.encript(client, app);
                // encriptar o resultado com a key interna
                processamento1 = CryptoUtil.encript(aux, ApplicationRegistration.GENERATION_RANDOM_KEY);
            }
            // Processamento 2
            {
                // Encriptar a data tendo como base a institui??o
                String aux = CryptoUtil.encript(_date, client);
                // encritar o resultado anterior com a applica??o
                aux = CryptoUtil.encript(aux, app);
                // encriptar o resultado anterior com a key interna.
                processamento2 = CryptoUtil.encript(aux, ApplicationRegistration.GENERATION_RANDOM_KEY);
            }
            // Jun??o dos dois resultados (processamento 1 e Procesasmento 2)
            {
                res = processamento1 + ApplicationRegistration.SPLITER_REGISTRATION_KEY + processamento2;
            }

        }
        catch (CryptException ce)
        {
            ce.printStackTrace();
            res = null;
        }
        return res;
    }

    /**
     * NOTHING.
     * 
     * @param numberOfapps
     *            NOTHING
     * @param clientName
     *            NOTHING
     */
    private static void generateAllKeys(int numberOfapps, String clientName)
    {
        System.out.println("Client -->" + clientName);
        for (int i = 1; i <= numberOfapps; i++)
        {
            String key = ApplicationRegistration.generateFullVersionKey(i + "", clientName);
            System.out.println("update programapplication set registrationkey = '" + key
                    + "' \n where applicationid = " + i + " and programid = <> ; \n");
        }
    }

    /**
     * NOTHING.
     * 
     * @param _app
     *            NOTHING
     * @param _client
     *            NOTHING
     * @return NOTHING
     */
    private static String generateFullVersionKey(String _app, String _client)
    {
        return ApplicationRegistration.encript(_client, _app, ApplicationRegistration.FULL_VERSION_DATE);
    }

    /**
     * NOTHING.
     * 
     * @param _app
     *            NOTHING
     * @param _client
     *            NOTHING
     * @param _date
     *            NOTHING
     * @return NOTHING
     */
    public static String generateTrialVersionKey(String _app, String _client, String _date)
    {
        return ApplicationRegistration.encript(_client, _app, _date);
    }

    /**
     * Gets the expirancy date.
     * 
     * @param _client
     *            the client that has registered the key
     * @param _app
     *            the registered application
     * @param _regKeyToCheck
     *            the key to check
     * @return the expirancy date of the key. null if the key is invalid, the application is not registered or the
     *         registration is for unlimited time.
     */
    public static Timestamp getEndDate(String _client, String _app, String _regKeyToCheck)
    {
        String client = StringUtil.removeAcentos(_client);
        String app = StringUtil.removeAcentos(_app);

        // Valida se a chave ? null ou se n?o tem a cadeia de caracteres que separa os dois processos
        if (!simpleKeyCheck(_regKeyToCheck))
        {
            return null;
        }

        Timestamp endDate = null;

        // Separa os dois processamentos da chave de registo
        String[] str = _regKeyToCheck.split(ApplicationRegistration.SPLITER_REGISTRATION_KEY);

        try
        {
            // Processamento 1 - IGNORADO, a data encontra-se apenas no 2? Processamento

            // Processamento 2
            {
                // Inverte o terceiro passo do segundo processamento
                String aux = CryptoUtil.deencript(str[1], ApplicationRegistration.GENERATION_RANDOM_KEY);

                // Inverte o segundo passo do segundo processamento
                aux = CryptoUtil.deencript(aux, app);

                // Obtem data de expira??o da chave de registo (primeiro passo do segundo processamento)
                String dateEnc = CryptoUtil.deencript(aux, client);

                // Verifica se ? uma trial version
                if (!dateEnc.equals(ApplicationRegistration.FULL_VERSION_DATE))
                {
                    Timestamp dateTrial = null;
                    Timestamp dateCur = null;
                    try
                    {
                        dateTrial = DateConverter.stringToTimestamp(dateEnc, ApplicationRegistration.DATE_FORMAT);

                        dateCur = DateConverter.longToTimestamp(System.currentTimeMillis(),
                                ApplicationRegistration.DATE_FORMAT);
                        // Se a trial terminou n?o poder? utilizar mais a chave
                        if (dateCur.after(dateTrial))
                        {
                            endDate = null;
                        }
                        else
                        {
                            endDate = dateTrial;
                        }
                    }
                    catch (ParseException pe)
                    {
                        pe.printStackTrace();
                        // Excep??o a fazer o parse da data, chave n?o est? correcta
                        endDate = null;
                    }
                }
                else
                {
                    endDate = null;
                }
            }
        }
        catch (CryptException ce)
        {
            ce.printStackTrace();
            endDate = null;
        }
        return endDate;
    }

    /**
     * The main method.
     * 
     * @param _args
     *            the arguments
     */
    public static void main(String[] _args)
    {
        String clientName = "IE";
        int maxApps = 25;
        if (_args.length > 0)
        {
            clientName = _args[0];
        }
        generateAllKeys(maxApps, clientName);

        String key = ApplicationRegistration.generateFullVersionKey("SIANET_TURMAS_HORARIOS", clientName);
        System.out.println("SIANET_TURMAS_HORARIOS=" + key);
        /*
         * for (int i = 0; i <= 13; i++) { String key = ApplicationRegistration.generateFullVersionKey(i+"",
         * "NetP@ Services - Digitalis Informtica, Lda (Verso Demo)");//, "10052005"); //String key =
         * ApplicationRegistration.generateTrialVersionKey(""+i,
         * "NetP@ Services - Digitalis Informtica, Lda (Verso Demo)", "10052005");
         * System.out.println("update programapplication set registrationkey = '"
         * +key+"' where applicationid = "+i+" and programid = <>\n\n"); System.out.println( "valid = "+checkKey(
         * "NetP@ Services - Digitalis Informtica, Lda (Verso Demo)", i+"", key));
         * System.out.println(" Date = "+getEndDate( "NetP@ Services - Digitalis Informtica, Lda (Verso Demo)", i+"",
         * key)+"\n\n\n"); }
         */
    }

    /**
     * Checks if the key has the correct format.
     * 
     * @param _regKeyToCheck
     *            the key to check
     * @return <code>true</code> if the key is not <code>null</code> and has the correct format
     */
    private static final boolean simpleKeyCheck(String _regKeyToCheck)
    {
        // Valida se a chave ? null ou se n?o tem a cadeia de caracteres que separa os dois processos
        if (_regKeyToCheck == null || _regKeyToCheck.indexOf(ApplicationRegistration.SPLITER_REGISTRATION_KEY) == -1)
        {
            return false;
        }
        return true;
    }
}
