/**
 * First created between November and December 2003 1994-2003 Digitalis Informatica. All rights reserved. Distribuicao e
 * Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21
 * 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package util.cripto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

import org.apache.commons.codec.binary.Base64;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to (de)encript a <code>String</code>.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 */
public final class CryptoUtil {

    // TODO : Before changing - Value must be replaced where it is used to decript
    /**
     * Default random key to be used for the (de)encryption of the <code>String</code>.
     */
    public static final String DEFAULT_KEY_STRING = "125SedgETmjlhjz";
    /**
     * Number of iteration, used for the encription.
     */
    private static final int iterations = 10;
    /**
     * 8-bytes Salt, used for the encription.
     */
    private static final byte[] salt = {(byte) 0xA9, (byte) 0x9B, (byte) 0xC8, (byte) 0x32, (byte) 0x56, (byte) 0x34,
                        (byte) 0xE3, (byte) 0x03};

    /**
     * Deencrypts a <code>String</code> based on the specified key.
     * 
     * @param _original
     *            the encrypted <code>String</code>
     * @param _key
     *            the key to use
     * @return the deencrypted <code>String</code>
     * @throws CryptException
     *             if an erro occur while attempting to deencrypt the <code>String</code>
     */
    public static String deencript(String _original, String _key) throws CryptException
    {
        String decoded = null;

        try
        {

            // Encode the string into bytes using utf-8 and Encrypt
            byte[] dec = CryptoUtil.getCipher(_key, Cipher.DECRYPT_MODE).doFinal(
                    Base64.decodeBase64(_original.getBytes()));

            // Encode bytes to base64 to get a string
            decoded = new String(dec, "UTF8");

        }
        catch (Exception e)
        {
            throw new CryptException(e);
        }
        return decoded;
    }

    /**
     * Encrypts a <code>String</code> based on {@link CryptoUtil#DEFAULT_KEY_STRING}.
     * 
     * @param _original
     *            the <code>String</code> to encript
     * @return the <code>String</code> encripted.
     */
    public static String encript(String _original)
    {
        return encript(_original, CryptoUtil.DEFAULT_KEY_STRING);
    }

    /**
     * Encrypts a <code>String</code> based on the specified key.
     * 
     * @param _original
     *            the <code>String</code> to encript
     * @param _key
     *            the key to be used
     * @return the <code>String</code> encripted.
     */
    public static String encript(String _original, String _key)
    {
        String encripted = null;

        try
        {
            // Encode the string into bytes using utf-8 and Encrypt
            byte[] enc = CryptoUtil.getCipher(_key, Cipher.ENCRYPT_MODE).doFinal(_original.getBytes("utf-8"));

            // Encode bytes to base64 to get a string
            encripted = new String(Base64.encodeBase64(enc));

        }
        catch (Exception e)
        {
            throw new CryptException(e);
        }
        return encripted;
    }

    /**
     * Gets the cipher to (de)encrypt the <code>String</code>.
     * 
     * @param _key
     *            the key to be used
     * @param _mode
     *            the mode to use the cipher (javax.crypto.Cipher#DECRYPT_MODE or javax.crypto.Cipher#ENCRYPT_MODE)
     * @return the cipher
     * @throws InvalidKeySpecException
     *             javax.crypto.SecretKeyFactory#generateSecret
     * @throws NoSuchAlgorithmException
     *             javax.crypto.SecretKeyFactory#getInstance, javax.crypto.Cipher#getInstance
     * @throws NoSuchPaddingException
     *             javax.crypto.Cipher#getInstance
     * @throws InvalidKeyException
     *             javax.crypto.Cipher#init
     * @throws InvalidAlgorithmParameterException
     *             javax.crypto.Cipher#init
     */
    private static Cipher getCipher(String _key, int _mode) throws InvalidKeySpecException, NoSuchAlgorithmException,
            NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException
    {
        // Prepare the parameters to the cipther
        KeySpec keySpec = new PBEKeySpec(_key.toCharArray(), salt, iterations, 10);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterations);

        // Create Cipher
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(_mode, secretKey, paramSpec);

        return cipher;
    }

    /**
     * The main method.
     * 
     * @param _args
     *            the arguments
     */
    public static void main(String[] _args)
    {
        int iteracoes = 100;
        String word = "1232213";
        ArrayList<String> encryptedWords = new ArrayList<String>();
        long start = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        System.out.println("Encryptation: ");
        for (int i = 0; i < iteracoes; i++)
        {
            encryptedWords.add(CryptoUtil.encript(word + i, DEFAULT_KEY_STRING));
        }
        long middle = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        System.out.println("Encryptation elapsed time: " + (middle - start) + " Seconds");
        System.out.println("Decryptation: ");
        for (int i = 0; i < encryptedWords.size(); i++)
        {
            System.out.println("Original : " + word + i);
            System.out.println("Encrypted : " + encryptedWords.get(i));
            System.out.println("Decrypted : " + CryptoUtil.deencript(encryptedWords.get(i), DEFAULT_KEY_STRING));
        }
        long end = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        System.out.println("Decryptation elapsed time: " + (end - middle) + " Seconds");
        System.out.println("Total elapsed time: " + (end - start) + " Seconds");
    }

}