/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.data;

import java.util.ArrayList;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * Utility class used to trnsform object types.
 * The final type may not be equal or equivalent to the original type.
 * 
 * @see util.data.Mutation
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a>
 * Created : 31/Mai/2006
 */
public class DataTransform {

	/**
	 * Mutates all the elements of a list into another data type. Each element is
	 * tranformed individualy and placed into a new List. The list of the mutated
	 * elements corresponde to the original list in terms of element position and
	 * size, this is, in the first position of the final list will be the mutated
	 * element of the element that is in the first position of the original list.
	 * 
	 * @param <O> the original type object
	 * @param <D> the destination type object
	 * @param listData the list with the original data types
	 * @param mutator the mutator used to transform the objects
	 * @return the list with the elements of the new data type
	 */
	public static <O, D extends Object> List<D> mutateListData(List<O> listData, Mutation<O, D> mutator) {
		List<D> destList = new ArrayList<D>();
		for (O originalData : listData) {
			destList.add(mutator.mutate(originalData));
		}
		return destList;
	}

	/**
	 * Mutates a list of objects (of any type) to String.<br />
	 * This method does not replace the toString of each object, though is usefull when
	 * just some attributes are to be used in the transformation of a list to string
	 *  
	 * @param <O> original object type to be transformed
	 * @param list the list with the objects to be transformed
	 * @param mut the mutator
	 * @param splitter the splitter of the objects in the string
	 * @return the string of objects
	 */
	public static <O extends Object> String mutateListToString(List<O> list, Mutation<O, String> mut, String splitter) {
		StringBuffer res = new StringBuffer();
		String aux = "";
		for (O listData : list) {
			res.append(aux + mut.mutate(listData));

			if (aux.equals("")) {
				aux = splitter;
			}
		}
		return res.toString();
	}
}
