package util.dateutils;

import java.util.Calendar;
import java.util.Date;
// TODO: Auto-generated Javadoc
/**
 * 1994-2008 Digitalis Informatica. All righsts reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 *
 * @author jgalaio <jgalaio@digitalis.pt>
 */
public class DateAuxFunctions {

	/**
	 * Devolve o numero de dias entra A e B.
	 * @param dateA primeira data de entrada.
	 * @param dateB segunda data de entrada.
	 * @return int reprensentando dias.
	 */
	public static int calculaDiasEntreDatas(Calendar dateA, Calendar dateB)
	{
		// Bug 7263
	    int tempDifference = 0;
	    int difference = 0;
	    Calendar earlier = Calendar.getInstance();
	    Calendar later = Calendar.getInstance();

	    if (dateA.compareTo(dateB) < 0)
	    {
	        earlier.setTime(dateA.getTime());
	        later.setTime(dateB.getTime());
	    }
	    else
	    {
	        earlier.setTime(dateB.getTime());
	        later.setTime(dateA.getTime());
	    }
	    while (earlier.get(Calendar.YEAR) != later.get(Calendar.YEAR))
	    {
	        tempDifference = 365 * (later.get(Calendar.YEAR) - earlier.get(Calendar.YEAR));
	        difference += tempDifference;

	        earlier.add(Calendar.DAY_OF_YEAR, tempDifference);
	    }

	    if (earlier.get(Calendar.DAY_OF_YEAR) != later.get(Calendar.DAY_OF_YEAR))
	    {
	        tempDifference = later.get(Calendar.DAY_OF_YEAR) - earlier.get(Calendar.DAY_OF_YEAR);
	        difference += tempDifference;

	        earlier.add(Calendar.DAY_OF_YEAR, tempDifference);
	    }
	    return difference;
	}

	/**
	 * Verifica se duas datas sao iguais.
	 *
	 * @param date1 data de a comparar.
	 * @param date2 data a comparar
	 * @return true, if is same date
	 */
	public static boolean isSameDate(Date date1, Date date2) {
		String strDate1 = DateConverter.dateToString(date1, DateConverter.DATE_FORMAT1);
		String strDate2 = DateConverter.dateToString(date2, DateConverter.DATE_FORMAT1);
		if (strDate1.equals(strDate2)) {
			return true;
		}
		return false;

	}

	/**
	 * Checks if is same date time.
	 *
	 * @param date1 the date1
	 * @param date2 the date2
	 * @return true, if is same date time
	 */
	public static boolean isSameDateTime(Date date1, Date date2) {
		String strDate1 = DateConverter.dateToString(date1, DateConverter.DATE_TIME_FORMAT1);
		String strDate2 = DateConverter.dateToString(date2, DateConverter.DATE_TIME_FORMAT1);
		if (strDate1.equals(strDate2)) {
			return true;
		}
		return false;
	}
}
