/**
 * First created between November and December 2003 1994-2003 Digitalis Informatica. All rights reserved. Distribuicao e
 * Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21
 * 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 * */

package util.dateutils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import util.ASCIIConstants;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to convert a date from/to several formats. Provides other date manipulation methods.
 */

public class DateConverter {

    /**
     * Date format "dd-MM-yyyy".
     */

    public static final String DATE_FORMAT1 = "dd-MM-yyyy";

    /**
     * Date format "dd/MM/yyyy".
     */

    public static final String DATE_FORMAT2 = "dd/MM/yyyy";

    /**
     * Date format "yyyy-MM-dd".
     */

    public static final String DATE_FORMAT3 = "yyyy-MM-dd";

    /**
     * Date format "yyyy/MM/dd".
     */

    public static final String DATE_FORMAT4 = "yyyy/MM/dd";

    /**
     * Date format "yyyyMMdd".
     */
    public static final String DATE_FORMAT5 = "yyyyMMdd";

    /**
     * Date format "dd-MM-yyyy hh:mm:ss".
     */

    public static final String DATE_TIME_FORMAT1 = "dd-MM-yyyy HH:mm:ss";

    /**
     * Date format "dd/MM/yyyy hh:mm:ss".
     */

    public static final String DATE_TIME_FORMAT2 = "dd/MM/yyyy HH:mm:ss";

    /**
     * Date format "yyyy-MM-dd hh:mm:ss".
     */

    public static final String DATE_TIME_FORMAT3 = "yyyy-MM-dd HH:mm:ss";

    /**
     * Date format "yyyy/MM/dd hh:mm:ss".
     */

    public static final String DATE_TIME_FORMAT4 = "yyyy/MM/dd HH:mm:ss";

    /**
     * Date format "dd-MM-yyyy hh:mm".
     */

    public static final String DATE_TIME_FORMAT5 = "dd-MM-yyyy HH:mm";

    /**
     * Abreviation names of week days in portuguese.
     */

    public static final String[] DAY_OF_WEEK_ABREV_NAME = new String[] {"Dom", "2" + ASCIIConstants.aabreviado,
                        "3" + ASCIIConstants.aabreviado, "4" + ASCIIConstants.aabreviado,
                        "5" + ASCIIConstants.aabreviado, "6" + ASCIIConstants.aabreviado, "Sab"};

    /**
     * Long names of week days in portuguese.
     */

    public static final String[] DAY_OF_WEEK_LONG_NAME = new String[] {"Domingo", "Segunda Feira",
                        "Ter" + ASCIIConstants.ccedil + "a Feira", "Quarta Feira",

                        "Quinta Feira", "Sexta Feira", "S" + ASCIIConstants.acute + "bado"};

    /**
     * Short names of week days in portuguese.
     */

    public static final String[] DAY_OF_WEEK_SHORT_NAME = new String[] {"Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"};

    /**
     * Milliseconds in a hour.
     */

    public static final int MILLIS_IN_HOUR = (1000 * 60) * 60;

    /**
     * Milliseconds in a minute.
     */

    public static final int MILLIS_IN_MINUTE = 1000 * 60;

    /**
     * Milliseconds in a second.
     */

    public static final int MILLIS_IN_SECOND = 1000;

    /**
     * Fullname of months in portuguese.
     */

    public static final String[] MONTH_LONG_NAME = new String[] {"Janeiro", "Fevereiro",
                        "Mar" + ASCIIConstants.ccedil + "o",

                        "Abril", "Maio", "Junho", "Julho",

                        "Agosto", "Setembro", "Outubro",

                        "Novembro", "Dezembro"};

    /**
     * Short names of months in portuguese.
     */

    public static final String[] MONTH_SHORT_NAME = new String[] {"Jan", "Fev", "Mar",

    "Abr", "Mai", "Jun", "Jul",

    "Ago", "Set", "Out",

    "Nov", "Dez"};

    /**
     * Time format "hh:mm:ss".
     */

    public static final String TIME_FORMAT1 = "HH:mm:ss";

    /**
     * Time format "hh:mm:ss:S".
     */

    public static final String TIME_FORMAT2 = "HH:mm:ss:S";

    /** The Constant TIME_FORMAT3. */
    public static final String TIME_FORMAT3 = "HH:mm";

    /**
     * Adds a certain amount of days to a date excluinding the weekends.
     * 
     * @param date
     *            the date to add days to
     * @param daysToAdd
     *            the number of days to add
     * @return the resulting date
     */
    public static Date addBusinessDays(Date date, int daysToAdd)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        int sumFactor = 1;
        if (daysToAdd < 0)
            sumFactor = -1;

        int absDays = Math.abs(daysToAdd);

        for (int i = 0; i < absDays; i++)
        {

            // adds one day
            cal.add(Calendar.DAY_OF_MONTH, sumFactor);

            // if the day is a weekend adds another days until reaches a business day
            while (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY
                    || cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY)
                cal.add(Calendar.DAY_OF_MONTH, sumFactor);
        }
        return cal.getTime();
    }

    /**
     * Adds a certain amount of days to a date.
     * 
     * @param date
     *            the date to add days to
     * @param daysToAdd
     *            the number of days to add
     * @return the resulting date
     */

    public static Date addDays(Date date, int daysToAdd)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        cal.add(Calendar.DAY_OF_MONTH, daysToAdd);

        return cal.getTime();

    }

    /**
     * Adds a certain amount of hours to a date.
     * 
     * @param date
     *            the date to add hours to
     * @param hoursToAdd
     *            the hours to add
     * @return the resulting date
     */

    public static Date addHours(Date date, int hoursToAdd)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        cal.add(Calendar.HOUR_OF_DAY, hoursToAdd);

        return cal.getTime();

    }

    /**
     * Adds a certain amount of minutes to a date.
     * 
     * @param date
     *            the date to add hours to
     * @param minutesToAdd
     *            the minutes to add
     * @return the resulting date
     */

    public static Date addMinutes(Date date, int minutesToAdd)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        cal.add(Calendar.MINUTE, minutesToAdd);

        return cal.getTime();

    }

    /**
     * Changes the format of the string that represents a date.
     * 
     * @param date1
     *            the date1
     * @param format1
     *            format of the string
     * @param format2
     *            desired format of the the result
     * @return String formated with the format 2 parameter
     */
    public static String changesStringFormat(String date1, String format1, String format2)
    {
        Date dt;
        String result = "";
        try
        {
            if (date1 != null && !date1.equals(""))
            {
                dt = DateConverter.stringToDate(date1, format1);
                result = DateConverter.dateToString(dt, format2);
            }
        }
        catch (ParseException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return result;
    }

    /**
     * Parses a <code>java.util.Date</code> to <code>String</code> format.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date in String format
     */

    public static String dateToString(Date date, String format)
    {

        SimpleDateFormat dateForm = new SimpleDateFormat(format);

        return dateForm.format(date);

    }

    /**
     * Parses a <code>java.util.Date</code> date to <code>java.sql.Timestamp</code>.
     * <p>
     * This method serves to strip the date.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date in Timestap format
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Timestamp dateToTimestamp(Date date, String format) throws ParseException
    {

        return new Timestamp(longToDate(date.getTime(), format).getTime());

    }

    /**
     * Parses a <code>java.sql.Timestamp</code> date to <code>java.sql.Timestamp</code>.
     * <p>
     * This method serves to strip the date.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date in Timestap format
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Timestamp formatedTimestamp(Timestamp date, String format) throws ParseException
    {

        return longToTimestamp(date.getTime(), format);

    }

    /**
     * Gets the day.
     * 
     * @param date
     *            the date to get the day from
     * @return the day
     */

    public static int getDay(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return cal.get(Calendar.DAY_OF_MONTH);

    }

    /**
     * Gets the day.
     * 
     * @param date
     *            the milliseconds date format
     * @return the day
     */

    public static int getDay(long date)
    {

        return DateConverter.getDay(new Date(date));

    }

    /**
     * Gets the day.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the day from
     * @return the day
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getDay(String date) throws ParseException
    {

        return DateConverter.getDay(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the day.
     * 
     * @param date
     *            the date to get the day from
     * @param format
     *            the format to use
     * @return the day
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getDay(String date, String format) throws ParseException
    {

        return DateConverter.getDay(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the day.
     * 
     * @param date
     *            the date to get the day from
     * @return the day
     */

    public static int getDay(Timestamp date)
    {

        return DateConverter.getDay((Date) date);

    }

    /**
     * Gets the day of week.
     * 
     * @param date
     *            the date to get the day of week from
     * @return the day of week
     */

    public static int getDayOfWeek(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return cal.get(Calendar.DAY_OF_WEEK);

    }

    /**
     * Gets the day of week.
     * 
     * @param date
     *            the milliseconds date format
     * @return the day of week
     */

    public static int getDayOfWeek(long date)
    {

        return DateConverter.getDayOfWeek(new Date(date));

    }

    /**
     * Gets the day of week.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the day of week from
     * @return the day of week
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getDayOfWeek(String date) throws ParseException
    {

        return DateConverter.getDayOfWeek(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the day of week.
     * 
     * @param date
     *            the date to get the day of week from
     * @param format
     *            the format to use
     * @return the day of week
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getDayOfWeek(String date, String format) throws ParseException
    {

        return DateConverter.getDayOfWeek(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the day of week.
     * 
     * @param date
     *            the date to get the day of week from
     * @return the day of week
     */

    public static int getDayOfWeek(Timestamp date)
    {

        return DateConverter.getDayOfWeek((Date) date);

    }

    /**
     * Gets the day of week abbreviation name.
     * 
     * @param date
     *            the date to get the day of week abbreviation name from
     * @return the day of week abbreviation name
     */

    public static String getDayOfWeekAbrvName(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return DateConverter.DAY_OF_WEEK_ABREV_NAME[cal.get(Calendar.DAY_OF_WEEK) - 1];

    }

    /**
     * Gets the day of week abbreviation name.
     * 
     * @param dayOfWeek
     *            the day of week number
     * @return the day of week abbreviation name
     */

    public static String getDayOfWeekAbrvName(Integer dayOfWeek)
    {

        return DateConverter.DAY_OF_WEEK_ABREV_NAME[dayOfWeek.intValue() - 1];

    }

    /**
     * Gets the day of week abbreviation name.
     * 
     * @param date
     *            the milliseconds date format
     * @return the day of week abbreviation name
     */

    public static String getDayOfWeekAbrvName(long date)
    {

        return DateConverter.getDayOfWeekAbrvName(new Date(date));

    }

    /**
     * Gets the day of week abbreviation name.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the day of week abbreviation name from
     * @return the day of week abbreviation name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekAbrvName(String date) throws ParseException
    {

        return DateConverter.getDayOfWeekAbrvName(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the day of week abbreviation name.
     * 
     * @param date
     *            the date to get the day of week abbreviation name from
     * @param format
     *            the format to use
     * @return the day of week abbreviation name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekAbrvName(String date, String format) throws ParseException
    {

        return DateConverter.getDayOfWeekAbrvName(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the day of week abbreviation name.
     * 
     * @param date
     *            the date to get the day of week abbreviation name from
     * @return the day of week abbreviation name
     */

    public static String getDayOfWeekAbrvName(Timestamp date)
    {

        return DateConverter.getDayOfWeekAbrvName((Date) date);

    }

    /**
     * Gets the day of week long name.
     * 
     * @param date
     *            the date to get the day of week long name from
     * @return the day of week long name
     */

    public static String getDayOfWeekLongName(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return DateConverter.DAY_OF_WEEK_LONG_NAME[cal.get(Calendar.DAY_OF_WEEK) - 1];

    }

    /**
     * Gets the day of week long name.
     * 
     * @param dayOfWeek
     *            the day of week number
     * @return the day of week long name
     */

    public static String getDayOfWeekLongName(Integer dayOfWeek)
    {

        return DateConverter.DAY_OF_WEEK_LONG_NAME[dayOfWeek.intValue() - 1];

    }

    /**
     * Gets the day of week long name.
     * 
     * @param date
     *            the milliseconds date format
     * @return the day of week long name
     */

    public static String getDayOfWeekLongName(long date)
    {

        return DateConverter.getDayOfWeekLongName(new Date(date));

    }

    /**
     * Gets the day of week long name.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the day of week long name from
     * @return the day of week long name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekLongName(String date) throws ParseException
    {

        return DateConverter.getDayOfWeekLongName(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the day of week long name.
     * 
     * @param date
     *            the date to get the day of week long name from
     * @param format
     *            the format to use
     * @return the day of week long name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekLongName(String date, String format) throws ParseException
    {

        return DateConverter.getDayOfWeekLongName(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the day of week long name.
     * 
     * @param date
     *            the date to get the day of week long name from
     * @return the day of week long name
     */

    public static String getDayOfWeekLongName(Timestamp date)
    {

        return DateConverter.getDayOfWeekLongName((Date) date);

    }

    /**
     * Gets the day of week short name.
     * 
     * @param date
     *            the date to get the day of week short name from
     * @return the day of week short name
     */

    public static String getDayOfWeekShortName(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return DateConverter.DAY_OF_WEEK_SHORT_NAME[cal.get(Calendar.DAY_OF_WEEK) - 1];

    }

    /**
     * Gets the day of week short name.
     * 
     * @param dayOfWeek
     *            the day of week number
     * @return the day of week short name
     */

    public static String getDayOfWeekShortName(Integer dayOfWeek)
    {

        return DateConverter.DAY_OF_WEEK_SHORT_NAME[dayOfWeek.intValue() - 1];

    }

    /**
     * Gets the day of week short name.
     * 
     * @param date
     *            the milliseconds date format
     * @return the day of week short name
     */

    public static String getDayOfWeekShortName(long date)
    {

        return DateConverter.getDayOfWeekShortName(new Date(date));

    }

    /**
     * Gets the day of week short name.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the day of week short name from
     * @return the day of week short name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekShortName(String date) throws ParseException
    {

        return DateConverter.getDayOfWeekShortName(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the day of week short name.
     * 
     * @param date
     *            the date to get the day of week short name from
     * @param format
     *            the format to use
     * @return the day of week short name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getDayOfWeekShortName(String date, String format) throws ParseException
    {

        return DateConverter.getDayOfWeekShortName(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the day of week short name.
     * 
     * @param date
     *            the date to get the day of week short name from
     * @return the day of week short name
     */

    public static String getDayOfWeekShortName(Timestamp date)
    {

        return DateConverter.getDayOfWeekShortName((Date) date);

    }

    /**
     * Gets the next monday date.
     * 
     * @param date
     *            the date to get the next monday
     * @return the next monday after <code>date</code>
     */

    public static Date getMonday(Date date)
    {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(date);
        calendarDate.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);

        return calendarDate.getTime();
    }

    /**
     * Gets the month number.
     * 
     * @param date
     *            the date to get the month from
     * @return the month number
     */

    public static int getMonth(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return cal.get(Calendar.MONTH) + 1;

    }

    /**
     * Gets the month number.
     * 
     * @param date
     *            the milliseconds date format
     * @return the month number
     */

    public static int getMonth(long date)
    {

        return DateConverter.getMonth(new Date(date));

    }

    /**
     * Gets the month number.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the month from
     * @return the month number
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getMonth(String date) throws ParseException
    {

        return DateConverter.getMonth(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the month number.
     * 
     * @param date
     *            the date to get the month from
     * @param format
     *            the format to use
     * @return the month short name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getMonth(String date, String format) throws ParseException
    {

        return DateConverter.getMonth(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the month number.
     * 
     * @param date
     *            the date to get the month from
     * @return the month number
     */

    public static int getMonth(Timestamp date) /* throws ParseException */
    {

        return DateConverter.getMonth((Date) date);

    }

    /**
     * Gets the month long name.
     * 
     * @param date
     *            the date to get the month from
     * @return the month long name
     */

    public static String getMonthName(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return DateConverter.MONTH_LONG_NAME[cal.get(Calendar.MONTH)];

    }

    /**
     * Gets the month long name.
     * 
     * @param date
     *            the milliseconds date format
     * @return the month long name
     */

    public static String getMonthName(long date)
    {

        return DateConverter.getMonthName(new Date(date));

    }

    /**
     * Gets the month long name.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the month from
     * @return the month long name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getMonthName(String date) throws ParseException
    {

        return DateConverter.getMonthName(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the month long name.
     * 
     * @param date
     *            the date to get the month from
     * @param format
     *            the format to use
     * @return the month long name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getMonthName(String date, String format) throws ParseException
    {

        return DateConverter.getMonthName(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the month long name.
     * 
     * @param date
     *            the date to get the month from
     * @return the month long name
     */

    public static String getMonthName(Timestamp date)
    {

        return DateConverter.getMonthName((Date) date);

    }

    /**
     * Gets the month short name.
     * 
     * @param date
     *            the date to get the month from
     * @return the month short name
     */

    public static String getMonthShortName(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return DateConverter.MONTH_SHORT_NAME[cal.get(Calendar.MONTH)];

    }

    /**
     * Gets the month short name.
     * 
     * @param date
     *            the milliseconds date format
     * @return the month short name
     */

    public static String getMonthShortName(long date)
    {

        return DateConverter.getMonthShortName(new Date(date));

    }

    /**
     * Gets the month short name.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the month from
     * @return the month short name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getMonthShortName(String date) throws ParseException
    {

        return DateConverter.getMonthShortName(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the month short name.
     * 
     * @param date
     *            the date to get the month from
     * @param format
     *            the format to use
     * @return the month short name
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static String getMonthShortName(String date, String format) throws ParseException
    {

        return DateConverter.getMonthShortName(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the month short name.
     * 
     * @param date
     *            the date to get the month from
     * @return the month short name
     */

    public static String getMonthShortName(Timestamp date) /* throws ParseException */
    {

        return DateConverter.getMonthShortName((Date) date);

    }

    /**
     * Gets the year.
     * 
     * @param date
     *            the date to get the year from
     * @return the year
     */

    public static int getYear(Date date)
    {

        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        return cal.get(Calendar.YEAR);

    }

    /**
     * Gets the year.
     * 
     * @param date
     *            the milliseconds date format
     * @return the year
     */

    public static int getYear(long date)
    {

        return DateConverter.getYear(new Date(date));

    }

    /**
     * Gets the year.
     * <p>
     * Uses the {@link DateConverter#DATE_FORMAT1} as format
     * 
     * @param date
     *            the date to get the year from
     * @return the year
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getYear(String date) throws ParseException
    {

        return DateConverter.getYear(DateConverter.stringToTimestamp(date, DateConverter.DATE_FORMAT1));

    }

    /**
     * Gets the year.
     * 
     * @param date
     *            the date to get the year from
     * @param format
     *            the format to use
     * @return the year
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static int getYear(String date, String format) throws ParseException
    {

        return DateConverter.getYear(DateConverter.stringToTimestamp(date, format));

    }

    /**
     * Gets the year.
     * 
     * @param date
     *            the date to get the year from
     * @return the year
     */

    public static int getYear(Timestamp date)
    {

        return DateConverter.getYear((Date) date);

    }

    /**
     * Parses a date in the millisecconds format to <code>java.util.Date</code>.
     * 
     * @param milli
     *            the milliseconds to convert
     * @param format
     *            the format to use
     * @return the date
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Date longToDate(long milli, String format) throws ParseException
    {

        SimpleDateFormat dateForm = new SimpleDateFormat(format);

        return dateForm.parse(longToString(milli, format));

    }

    /**
     * Parses a date in milliseconds format to <code>String</code> format.
     * 
     * @param milli
     *            the milliseconds to convert
     * @param format
     *            the format to use
     * @return the date in String format
     */

    public static String longToString(long milli, String format)
    {

        return DateConverter.dateToString(new Date(milli), format);

    }

    /**
     * Parses a date in the millisecconds format to <code>java.sql.Timestamp</code>.
     * 
     * @param milli
     *            the milliseconds to convert
     * @param format
     *            the format to use
     * @return the date in Timestap format
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Timestamp longToTimestamp(long milli, String format) throws ParseException
    {

        return new Timestamp(longToDate(milli, format).getTime());

    }

    /**
     * Parses a <code>String</code> date to <code>java.util.Date</code>.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Date stringToDate(String date, String format) throws ParseException
    {

        SimpleDateFormat dateForm = new SimpleDateFormat(format);

        return dateForm.parse(date);

    }

    /**
     * Parses a <code>String</code> date to millisecconds.
     * 
     * @param date
     *            the date
     * @param format
     *            the format in which the date is
     * @return milliseconds date
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static long stringToLong(String date, String format) throws ParseException
    {

        SimpleDateFormat dateForm = new SimpleDateFormat(format);

        return dateForm.parse(date).getTime();

    }

    /**
     * Parses a <code>String</code> date to <code>java.sql.Timestamp</code>.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date in Timestap format
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Timestamp stringToTimestamp(String date, String format) throws ParseException
    {

        return new Timestamp(stringToDate(date, format).getTime());

    }

    /**
     * Parses a <code>java.sql.Timestamp</code> date to <code>java.util.Date</code>.
     * <p>
     * As <code>java.sql.Timestamp</code> is <code>java.util.Date</code>, this method serves to strip the date.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date
     * @throws ParseException
     *             if the date isn't parsable
     */

    public static Date timestampToDate(Timestamp date, String format) throws ParseException
    {

        return longToDate(date.getTime(), format);

    }

    /**
     * Parses a <code>java.sql.Timestamp</code> to <code>String</code> format.
     * 
     * @param date
     *            the date to convert
     * @param format
     *            the format to use
     * @return the date in String format
     */

    public static String timestampToString(Timestamp date, String format)
    {

        return DateConverter.dateToString(date, format);

    }

}