/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.dateutils;


// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to process time data.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 */
public class TimeConverter {
	/**
	 * Sums some minutos.
	 * @param minutes minutes
	 * @param toAdd   number of minutes to add
	 * @return the result of the sum.
	 */
	public static int addMinutes(String minutes, String toAdd){
		int minInt;
		try {
			minInt = Integer.parseInt(minutes, 10);
		} catch (NumberFormatException nfe) {
			System.out.print(nfe.toString());
			return 0;
		}
		try {
			minInt += Integer.parseInt(toAdd, 10);
		} catch (NumberFormatException nfe) {
			System.out.print(nfe.toString());
			return 0;
		}
		return minInt;
	}
	/**
	 * Converts minutes to time format "hh:mm".
	 * @param minutes the number of minutes
	 * @return the time format
	 */
	public static String minutesToHoursString(int minutes){
		int hours = (minutes / 60);
		int restMins = minutes-(hours*60);
		return (hours<10?"0":"")+hours+":"+(restMins<10?"0":"")+restMins;
	}
	/**
	 * Converts minutes to time format "hh:mm".
	 * @param minutes the number of minutes
	 * @return the time format
	 */
	public static String minutesToHoursString(String minutes){
		int intVar;
		try {
			intVar = Integer.parseInt(minutes, 10);
		} catch (NumberFormatException nfe) {
			System.out.print(nfe.toString());
			return ""; 
		}
		return minutesToHoursString( intVar);
	}

	/**
	 * Converts a time format ("hh:mm") to minutes.
	 * @param time the time to convert into minutes
	 * @return the number of minutes
	 */
	public static int stringToMinutes(String time){
		int doubleDotInd = time.indexOf(":");
		int minutes = 0;
		if(doubleDotInd != -1){
			String hourStr = time.substring(0, doubleDotInd);
			String minStr = time.substring(doubleDotInd+1, doubleDotInd+3);
			minutes = (Integer.parseInt( hourStr, 10)*60)+Integer.parseInt( minStr, 10);
		}
		return minutes;
	}
}
