/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.html;

// TODO: Auto-generated Javadoc
/**
 * Utility class used for the manipulation of a query of an URL.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a>
 * Created : 21/Fev/2006
 */
public class QueryHtmlUtil {
	
	/** The Constant PARAMETER_CHARS_ORIGINAL. */
	private static final String[] PARAMETER_CHARS_ORIGINAL = new String[]{ "\r\n","","" };
	
	/** The Constant PARAMETER_CHARS_ORIGINAL_REG_EXP. */
	private static final String[] PARAMETER_CHARS_ORIGINAL_REG_EXP = PARAMETER_CHARS_ORIGINAL;
	
	/** The Constant PARAMETER_CHARS_REPLACED. */
	private static final String[] PARAMETER_CHARS_REPLACED = new String[]{ "p!enter!p","p!l_ccedil!p","p!u_ccedil!p"};
	
	/** The Constant PARAMETER_CHARS_REPLACED_REG_EXP. */
	private static final String[] PARAMETER_CHARS_REPLACED_REG_EXP = PARAMETER_CHARS_REPLACED;


	/** The Constant QUERY_CHARS_ORIGINAL. */
	private static final String[] QUERY_CHARS_ORIGINAL = new String[]{ "&", "?", "="};
	
	/** The Constant QUERY_CHARS_ORIGINAL_REG_EXP. */
	private static final String[] QUERY_CHARS_ORIGINAL_REG_EXP = new String[]{ "&", "\\?", "="};
	
	/** The Constant QUERY_CHARS_REPLACED. */
	private static final String[] QUERY_CHARS_REPLACED = new String[]{ "m!1!m", "m!2!m", "m!3!m"};
	
	/** The Constant QUERY_CHARS_REPLACED_REG_EXP. */
	private static final String[] QUERY_CHARS_REPLACED_REG_EXP = new String[]{ "m!1!m", "m!2!m", "m!3!m"};
	
	/**
	 * Encondes a parameter so that it's white space parameters may be passed by an Ajax request.<br />
	 * The white spaces that are thaken into account are specified by the @link QueryHtmlUtil#PARAMETER_CHARS_ORIGINAL.<br />
	 * To decode the parameter use the @link QueryHtmlUtil#decodeParameter(String) method.
	 * 
	 * @param paramToCode the parameter to encode
	 * @return the parameter encoded
	 */
	public static String codeParameter( String paramToCode) {
		String result = paramToCode;
		for( int i=0;i<PARAMETER_CHARS_ORIGINAL_REG_EXP.length;i++){
			result = result.replace(PARAMETER_CHARS_ORIGINAL_REG_EXP[i], PARAMETER_CHARS_REPLACED[i]);
		}
		return result;
	}
	
	/**
	 * Decodes an parameters encoded by the (@link QueryHtmlUtil#codeParameter(String)) method.
	 * 
	 * @param paramToDecode the parameter to decode
	 * @return the parameter decoded that was previously coded by the QueryHtmlUtil.encodeURL(String) method
	 */
	public static String decodeParameter(String paramToDecode) {
		String result = paramToDecode;

		for( int i=0;i<PARAMETER_CHARS_REPLACED_REG_EXP.length;i++) {
			result = result.replace(PARAMETER_CHARS_REPLACED_REG_EXP[i], PARAMETER_CHARS_ORIGINAL[i]);
		}
		return result;
	}
	
	/**
	 * Decodes an URL encoded by the (@link QueryHtmlUtil#encodeURL(String)) method.
	 * 
	 * @param urlToDecode the URL to decode
	 * @return the URL decoded that was previously coded by the QueryHtmlUtil.encodeURL(String) method
	 */
	public static String decodeURL(String urlToDecode) {
		String result = urlToDecode;
		for(int i=0;i<QUERY_CHARS_REPLACED_REG_EXP.length;i++) {
			result = result.replace(QUERY_CHARS_REPLACED_REG_EXP[i], QUERY_CHARS_ORIGINAL[i]);
		}
		return result;
	}
	
	/**
	 * Encondes an URL so that it may be passed as an URL parameter.<br />
	 * Transfors the '<code>&</code>', '<code>?</code>' and '<code>=</code>' chatacters into a corresponding internal code.
	 * To decode the URL the @link QueryHtmlUtil#decodeURL(String) method may be invoked
	 * 
	 * @param urlToEncode the url to encode
	 * @return the URL encoded
	 */
	public static String encodeURL(String urlToEncode){
		String result = urlToEncode;
	 	
		for( int i=0;i<QUERY_CHARS_ORIGINAL_REG_EXP.length;i++){
			result = result.replace(QUERY_CHARS_ORIGINAL_REG_EXP[i], QUERY_CHARS_REPLACED[i]);
		}
		return result;
	}
}
