/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.html;

import java.util.HashMap;

// TODO: Auto-generated Javadoc
/**
 * Utility class that converts ascii characters into the quoted equivalent.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a>
 * Created : 31/Mai/2006
 */
public class SpecialChars {
	
	/** The char codes. */
	private static HashMap<String, String> charCodes;
	static {
		charCodes = new HashMap<String, String>();
		
		charCodes.put("", "&lsquo;");
		charCodes.put("", "&rsquo;");
		charCodes.put("", "&sbquo;");
		charCodes.put("", "&ldquo;");
		charCodes.put("", "&rdquo;");
		charCodes.put("", "&bdquo;");
		charCodes.put("", "&dagger;");
		charCodes.put("", "&Dagger;");
		charCodes.put("", "&permil;");
		charCodes.put("", "&lsaquo;");
		charCodes.put("", "&rsaquo;");
		charCodes.put("\"", "&quot;");
		charCodes.put("&", "&amp;");
		charCodes.put("/", "&frasl;");
		charCodes.put("<", "&lt;");
		charCodes.put(">", "&gt;");
		charCodes.put("", "&ndash;");
		charCodes.put("", "&mdash;");
		//charCodes.put(" ", "&nbsp;");
		charCodes.put("", "&iexcl;");
		charCodes.put("", "&cent;");
		charCodes.put("", "&pound;");
		charCodes.put("", "&curren;");
		charCodes.put("", "&yen;");
		charCodes.put("", "&brvbar;");
		charCodes.put("", "&sect;");
		charCodes.put("", "&uml;");
		charCodes.put("", "&copy;");
		charCodes.put("", "&copy;");
		charCodes.put("", "&ordf;");
		charCodes.put("", "&laquo;");
		charCodes.put("", "&not;");
		charCodes.put("", "&shy;");
		charCodes.put("", "&reg;");
		charCodes.put("&", "&acr;");
		charCodes.put("", "&deg;");
		charCodes.put("", "&plusmn;");
		charCodes.put("", "&sup2;");
		charCodes.put("", "&sup3;");
		charCodes.put("", "&acute;");
		charCodes.put("", "&micro;");
		charCodes.put("", "&para;");
		charCodes.put("", "&middot;");
		charCodes.put("", "&cedil;");
		charCodes.put("", "&sup1;");
		charCodes.put("", "&ordm;");
		charCodes.put("", "&raquo;");
		charCodes.put("", "&frac14;");
		charCodes.put("", "&frac12;");
		charCodes.put("", "&frac34;");
		charCodes.put("", "&iquest;");
		charCodes.put("", "&Agrave;");
		charCodes.put("", "&Aacute;");
		charCodes.put("", "&Acirc;");
		charCodes.put("", "&Atilde;");
		charCodes.put("", "&Auml;");
		charCodes.put("", "&Aring;");
		charCodes.put("", "&AElig;");
		charCodes.put("", "&Ccedil;");
		charCodes.put("", "&Egrave;");
		charCodes.put("", "&Eacute;");
		charCodes.put("", "&Ecirc;");
		charCodes.put("", "&Euml;");
		charCodes.put("", "&Igrave;");
		charCodes.put("", "&Iacute;");
		charCodes.put("", "&Icirc;");
		charCodes.put("", "&Iuml;");
		charCodes.put("", "&ETH;");
		charCodes.put("", "&Ntilde;");
		charCodes.put("", "&Ograve;");
		charCodes.put("", "&Oacute;");
		charCodes.put("", "&Ocirc;");
		charCodes.put("", "&Otilde;");
		charCodes.put("", "&Ouml;");
		charCodes.put("", "&times;");
		charCodes.put("", "&Oslash;");
		charCodes.put("", "&Ugrave;");
		charCodes.put("", "&Uacute;");
		charCodes.put("", "&Ucirc;");
		charCodes.put("", "&Uuml;");
		charCodes.put("", "&Yacute;");
		charCodes.put("", "&THORN;");
		charCodes.put("", "&szlig;");
		charCodes.put("", "&agrave;");
		charCodes.put("", "&aacute;");
		charCodes.put("", "&acirc;");
		charCodes.put("", "&atilde;");
		charCodes.put("", "&auml;");
		charCodes.put("", "&aring;");
		charCodes.put("", "&aelig;");
		charCodes.put("", "&ccedil;");
		charCodes.put("", "&egrave;");
		charCodes.put("", "&eacute;");
		charCodes.put("", "&ecirc;");
		charCodes.put("", "&euml;");
		charCodes.put("", "&igrave;");
		charCodes.put("", "&iacute;");
		charCodes.put("", "&icirc;");
		charCodes.put("", "&iuml;");
		charCodes.put("", "&eth;");
		charCodes.put("", "&ntilde;");
		charCodes.put("", "&ograve;");
		charCodes.put("", "&oacute;");
		charCodes.put("", "&ocirc;");
		charCodes.put("", "&otilde;");
		charCodes.put("", "&ouml;");
		charCodes.put("", "&divide;");
		charCodes.put("", "&oslash;");
		charCodes.put("", "&ugrave;");
		charCodes.put("", "&uacute;");
		charCodes.put("", "&ucirc;");
		charCodes.put("", "&uuml;");
		charCodes.put("", "&yacute;");
		charCodes.put("", "&thorn;");
		charCodes.put("", "&yuml;");
	}
	
	/**
	 * Converts one character based on the known list.<br />
	 * If the character is not in the list then it's ignored and returned 'as is'.
	 *  
	 * @param charToConvert the character to process
	 * @return the equivalent quoted code of the character or itself 
	 */
	public static String covertChar(char charToConvert){
		String res = charCodes.get( charToConvert+"");
		return res == null ? charToConvert+"" : res;
	}
	
	/**
	 * Converts all the characters of the string into the equivalent quoted code.
	 *
	 * @param strToProcess the string to converts
	 * @return the string processeds
	 * @see #covertChar(char)
	 */
	public static String processString( String strToProcess){
		StringBuffer res = new StringBuffer();
		for (int i = 0; i < strToProcess.length(); i++) {
			res.append( SpecialChars.covertChar( strToProcess.charAt(i)));
		}
		return res.toString();
	}
}
