/**
 * First created between November and December 2003 1994-2003 Digitalis Informatica. All rights reserved. Distribuicao e
 * Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21
 * 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.exception.IoCException;
import pt.digitalis.utils.ioc.guice.IoCRegistryGuiceImpl;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to manipulate the files.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 *         Created on 24/Nov/2004
 */
public class FileUtil {

    /**
     * Delete file.
     * 
     * @param fullFilePath
     *            the full file path
     */
    public static void deleteFile(String fullFilePath)
    {

        // A File object to represent the filename
        File f = new File(fullFilePath);

        // Make sure the file or directory exists and isn't write protected
        if (!f.exists())
            throw new IllegalArgumentException("Delete: no such file or directory: " + fullFilePath);

        if (!f.canWrite())
            throw new IllegalArgumentException("Delete: write protected: " + fullFilePath);

        // If it is a directory, make sure it is empty
        if (f.isDirectory())
        {
            String[] files = f.list();
            if (files.length > 0)
                throw new IllegalArgumentException("Delete: directory not empty: " + fullFilePath);
        }

        // Attempt to delete it
        boolean success = f.delete();

        if (!success)
            throw new IllegalArgumentException("Delete: deletion failed");
    }

    /**
     * Returns the temp file of the system.
     * <p>
     * 
     * @return String the temp file name .
     */
    public static String getTempDir()
    {
        AbstractConfigurationsImpl configs;
        String tmpDir = "";
        try
        {
            configs = (AbstractConfigurationsImpl) IoCRegistryGuiceImpl.getRegistry().getImplementation(
                    IConfigurations.class);
            Properties propsSIGES = configs.readConfiguration("netpa", "Config/General");

            tmpDir = propsSIGES.getProperty("TempDir");

            if ("#DefaultValue#".equals(tmpDir))
                tmpDir = "";

        }
        catch (IoCException e)
        {
            e.printStackTrace();
        }

        String dir = "";

        if (StringUtils.isNotBlank(tmpDir))
            dir = tmpDir;
        else
            dir = System.getProperty("java.io.tmpdir");

        if (dir.endsWith(File.separator))
            return dir;
        else
            return dir + File.separator;
    }

    /**
     * Loads the content of a file.
     * <p>
     * <b>NOTE</b> : Use with care, if the file is to large it may cause some instability in the system.
     * 
     * @param _f
     *            the file to load the content from
     * @return the file content
     * @throws FileNotFoundException
     *             If the specified path by the <code>File</code> object does not exist
     * @throws IOException
     *             If an error occur while trying to open or read from the file
     */
    public static String loadFile(File _f) throws FileNotFoundException, IOException
    {
        FileReader in = new FileReader(_f);

        StringBuffer scriptBuf = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        // Carrega o script para memoria
        while ((len = in.read(buf, 0, 1024)) != -1)
        {
            scriptBuf.append(buf, 0, len);
        }
        return scriptBuf.toString();
    }

}
