/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to manipulate streams.
 * 
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * Created : 12/Mai/2005
 */
public class StreamUtil {

	/**
	 * Copies the content of a stream to another.
	 * <p>
	 * The output stream will automatically flush.
	 * @param from the stream to read from
	 * @param to   the stream to read to
	 * @throws IOException if an error occur while tranfering the content
	 */
	public static void copy( InputStream from, OutputStream to) throws IOException {
		StreamUtil.copy(from, to, true);
	}

	/**
	 * Copies the content of a stream to another.
	 * <p>
	 * The output stream will flush only if the flag <code>flush</code> is active.
	 * @param from the stream to read from
	 * @param to   the stream to read to
	 * @param flush flag that specifies if the output stream should be flushed or not
	 * @throws IOException if an error occur while tranfering the content
	 */
	public static void copy( InputStream from, OutputStream to, boolean flush) throws IOException {
		byte[] buf = new byte[1024];
		int len = 0;

		// Copies the content from a stream to another
		if (from != null && to != null){
			while((len = from.read( buf, 0, 1024)) != -1){
	
				to.write(buf, 0, len);
			}
			if(flush){
				to.flush();
			}
		}
	}

	/**
	 * Create file from given InputStream.
	 * @param inputStream The stream use to create the file.
	 * @param fullPath The full path where the file is going to be created. 
	 * @throws Exception if an error occur while tranfering the content
	 */
	public static void createFileFormInputStream(InputStream inputStream, String fullPath) throws Exception {

		
		File myfile = new File(fullPath);
		
		BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myfile));
		BufferedInputStream ios = new BufferedInputStream(inputStream);
		
		StreamUtil.copy(ios, bos, true);
		
		bos.flush();
		bos.close();
		ios.close();
	}
	/**
	 * Loads the content of a stream into a String.
	 * @param stream the stream to be read
	 * @return the content of the stream
	 * @throws IOException in an error occur while reading ths content of the stream
	 */
	public static String readStream(InputStream stream) throws IOException {
		StringBuffer data = new StringBuffer();

		BufferedReader in = new BufferedReader(new InputStreamReader( stream));
		String inputLine;
		while ((inputLine = in.readLine()) != null) {
			data.append( inputLine);
		}

		return data.toString();
	}
}
	