package util.json;

import java.util.Arrays;

import pt.digitalis.dif.controller.http.JSONResponseBuilder;

// TODO: Auto-generated Javadoc
/**
 * The Class JsonUtil.
 *
 * @author Joao Galaio<jgalaio@digitalis.pt> Generic class. Classe utilitaria de json.
 */

public class JsonUtil {

    /**
     * Serialize the records to Json form.
     *
     * @param <T>
     *            the Generic.
     * @param mapData
     *            the json map node.
     * @param classe
     *            the Class.
     * @param array
     *            the array of object to serialize.
     * @return the json formated String.
     */
    public static <T extends Object> String serializeToJSON(String mapData, Class<T> classe, Object[] array)
    {
        return "{\"" + mapData + "\":" + JSONResponseBuilder.buildJSONResponse(Arrays.asList(array)) + "} ";
    }

    /**
     * Transform the ComboBOx records to json form.
     *
     * @param <T>
     *            the generic.
     * @param dataObject
     *            the data object.
     * @param total
     *            the records total.
     * @param clazz
     *            the Class to pass.
     * @return the JSON format.
     */
    public static <T extends Object> String transformToJSONComboBox(Object[] dataObject, long total, Class<T> clazz)
    {
        JsonUtil jsonUtil = new JsonUtil();
        String result = jsonUtil.transformToJSON("records", clazz, dataObject, total);
        return result;
    }

    /**
     * Transform data to JSON format.
     *
     * @param <T>
     *            the generic type
     * @param root
     *            the JSON root Element.
     * @param classe
     *            the class name.
     * @param array
     *            the values array.
     * @param total
     *            the total
     * @return the JSON format.
     */
    public <T extends Object> String transformToJSON(String root, Class<T> classe, Object[] array, long total)
    {
        String result;
        result = serializeToJSON(root, classe, array);
        result = "{'total':" + total + ", " + result.substring("{".length(), result.length() - 1);
        return result;
    }
}
