/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.reflection;

import java.lang.reflect.InvocationTargetException;

// TODO: Auto-generated Javadoc
/**
 * The Class ClassUtil.
 */
public class ClassUtil {
	
	/**
	 * Creates the new instance.
	 *
	 * @param _className the _class name
	 * @return the object
	 * @throws ClassNotFoundException the class not found exception
	 * @throws InstantiationException the instantiation exception
	 * @throws IllegalAccessException the illegal access exception
	 * @throws NoSuchMethodException the no such method exception
	 * @throws InvocationTargetException the invocation target exception
	 */
	public static Object createNewInstance(String _className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
		return (createNewInstance(_className, null));
	}

	/**
	 * Creates the new instance.
	 *
	 * @param _className the _class name
	 * @param _params the _params
	 * @return the object
	 * @throws ClassNotFoundException the class not found exception
	 * @throws InstantiationException the instantiation exception
	 * @throws IllegalAccessException the illegal access exception
	 * @throws NoSuchMethodException the no such method exception
	 * @throws InvocationTargetException the invocation target exception
	 */
	public static Object createNewInstance(String _className, Object[] _params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
		Object retValue = null;
		// create the parameter types array
		Class<?>[] _paramsClass = null;
		if (_params != null) {
			_paramsClass = new Class[_params.length];
			for (int i = 0; i < _paramsClass.length; i++) {
				_paramsClass[i] = _params[i].getClass();
			}
		}
		// get the Class
		Class<?> classToInstance = Class.forName(_className);
		// finnaly get an instance , by invoking the constructor's newInstance method.
		retValue = classToInstance.getConstructor(_paramsClass).newInstance(_params);
		return (retValue);
	}
}
